/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.audio.processing;

import java.util.ArrayList;
import java.util.List;
import org.robokind.api.audio.processing.SampleProcessor;

public class MeanCalculator
implements SampleProcessor {
    private Double[][] myVals;
    private Double[] myMean;
    private Double[] myStd;
    private int myChannels;
    private List<SampleProcessor.ProcessorListener> myListeners;

    public MeanCalculator(int channels) {
        this.myChannels = channels;
        this.myVals = new Double[channels][];
        for (int c = 0; c < this.myChannels; ++c) {
            this.myVals[c] = new Double[]{0.0, 0.0, 0.0};
        }
        this.myMean = new Double[this.myChannels];
        this.myStd = new Double[this.myChannels];
        this.myListeners = new ArrayList<SampleProcessor.ProcessorListener>(3);
    }

    @Override
    public void addProcessorListener(SampleProcessor.ProcessorListener listener) {
        if (listener == null || this.myListeners.contains(listener)) {
            return;
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeProcessorListener(SampleProcessor.ProcessorListener listener) {
        this.myListeners.remove(listener);
    }

    protected void fireProcessorUpdate(int count, int total) {
        for (SampleProcessor.ProcessorListener pl : this.myListeners) {
            pl.framesProcessed(count, total);
        }
    }

    @Override
    public void processSamples(double[][] samples, int frame, int total) {
        for (int c = 0; c < this.myChannels; ++c) {
            for (double s : samples[c]) {
                Double[] doubleArray = this.myVals[c];
                Double.valueOf(doubleArray[1] + s);
                doubleArray = this.myVals[c];
                Double.valueOf(doubleArray[2] + s * s);
            }
            Double[] doubleArray = this.myVals[c];
            Double.valueOf(doubleArray[0] + (double)samples[c].length);
            this.myMean[c] = null;
            this.myStd[c] = null;
        }
        this.fireProcessorUpdate(frame, total);
    }

    public double getMean(int c) {
        if (this.myMean[c] == null) {
            this.myMean[c] = this.myVals[c][1] / this.myVals[c][0];
        }
        return this.myMean[c];
    }

    public double getStd(int c) {
        if (this.myStd[c] == null) {
            this.myStd[c] = 1.0 / this.myVals[c][0] * Math.sqrt(this.myVals[c][0] * this.myVals[c][2] - this.myVals[c][1] * this.myVals[c][1]);
        }
        return this.myStd[c];
    }

    public double normalize(int c, double x) {
        return (x - this.getMean(c)) / this.getStd(c);
    }
}

