/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.osgi;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.robokind.api.common.osgi.ServiceLifecycleProvider;
import org.robokind.api.common.osgi.ServiceRequirementDescriptor;

public abstract class AbstractLifecycleProvider<I, T extends I>
implements ServiceLifecycleProvider<I> {
    private List<ServiceRequirementDescriptor> myDescriptors;
    protected T myService;
    protected Properties myRegistrationProperties;

    public AbstractLifecycleProvider(List<ServiceRequirementDescriptor> reqs) {
        if (reqs == null) {
            throw new NullPointerException();
        }
        this.myDescriptors = reqs;
    }

    @Override
    public void start(Map<String, Object> dependencies) {
        if (dependencies == null) {
            throw new NullPointerException();
        }
        if (!ServiceLifecycleProvider.Validator.validateServices(this.myDescriptors, dependencies)) {
            throw new IllegalArgumentException("Invalid Dependency set for factory.");
        }
        this.myService = this.create(dependencies);
    }

    protected abstract T create(Map<String, Object> var1);

    @Override
    public T getService() {
        return this.myService;
    }

    @Override
    public Properties getRegistrationProperties() {
        return this.myRegistrationProperties;
    }

    @Override
    public List<ServiceRequirementDescriptor> getServiceRequirements() {
        return this.myDescriptors;
    }

    @Override
    public void requiredServiceChanged(String serviceId, Object service) {
        if (serviceId == null) {
            throw new NullPointerException();
        }
        this.validate(serviceId, service);
        this.handleChange(serviceId, service);
    }

    protected abstract void handleChange(String var1, Object var2);

    private void validate(String id, Object req) {
        List<ServiceRequirementDescriptor> reqs = this.getServiceRequirements();
        if (req != null) {
            if (ServiceLifecycleProvider.Validator.validateService(reqs, id, req)) {
                return;
            }
            throw new IllegalArgumentException("Invalid service or id.  id: " + id + ", service: " + req);
        }
        if (ServiceLifecycleProvider.Validator.validateServiceId(reqs, id)) {
            return;
        }
        throw new IllegalArgumentException("Invalid service id: " + id + ".");
    }
}

