/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.osgi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.osgi.ServiceLifecycleProvider;
import org.robokind.api.common.osgi.ServiceRequirementDescriptor;
import org.robokind.api.common.osgi.ServiceRequirementsTracker;

public class DynamicServiceLauncher<T> {
    private static final Logger theLogger = Logger.getLogger(DynamicServiceLauncher.class.getName());
    private BundleContext myContext;
    private ServiceLifecycleProvider<T> myLifecycleProvider;
    private ServiceRequirementsTracker myRequirementsTracker;
    private T myService;
    private ServiceRegistration myServiceRegistration;
    private Properties myRegistrationProperties;
    private String myRegistrationClassName;
    private boolean myInitializedFlag;

    public DynamicServiceLauncher(BundleContext context, ServiceLifecycleProvider<T> factory) {
        this(context, factory, factory.getServiceClass().getName(), null);
    }

    public DynamicServiceLauncher(BundleContext context, ServiceLifecycleProvider<T> factory, Properties registrationProps) {
        this(context, factory, factory.getServiceClass().getName(), registrationProps);
    }

    public DynamicServiceLauncher(BundleContext context, ServiceLifecycleProvider<T> provider, String registrationClassName, Properties registrationProps) {
        if (context == null || provider == null || registrationClassName == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myLifecycleProvider = provider;
        List<ServiceRequirementDescriptor> descriptors = this.myLifecycleProvider.getServiceRequirements();
        if (descriptors == null) {
            throw new NullPointerException();
        }
        this.myRequirementsTracker = new ServiceRequirementsTracker(this.myContext);
        for (ServiceRequirementDescriptor dd : descriptors) {
            this.myRequirementsTracker.addRequirement(dd.getServiceClass(), dd.getRequirementId(), dd.getServiceFilter());
        }
        this.myRequirementsTracker.addPropertyChangeListener(new RequirementStatusListener());
        this.myRegistrationClassName = registrationClassName;
        this.myRegistrationProperties = registrationProps;
        this.myInitializedFlag = false;
    }

    public void start() {
        this.myRequirementsTracker.start();
    }

    public void stop() {
        this.myRequirementsTracker.stop();
    }

    public void unregisterService() {
        this.myService = null;
        if (this.myServiceRegistration == null) {
            return;
        }
        this.myServiceRegistration.unregister();
        this.myServiceRegistration = null;
    }

    private void handleRequiredServices(Map<String, Object> requiredServices) {
        if (this.myService != null) {
            return;
        }
        if (!ServiceLifecycleProvider.Validator.validateServices(this.myLifecycleProvider.getServiceRequirements(), requiredServices)) {
            throw new IllegalArgumentException("Invalid requirement set for service.");
        }
        this.myLifecycleProvider.start(requiredServices);
        this.myService = this.myLifecycleProvider.getService();
        if (this.myService == null) {
            theLogger.warning("The factory failed to create a service and returned null.");
            return;
        }
        theLogger.log(Level.INFO, "Service created of type {0}", this.myLifecycleProvider.getServiceClass());
        this.registerService();
    }

    private void handleChanged(String id, Object newService) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (!this.validate(id, newService)) {
            throw new IllegalArgumentException("Invalid service or id.  id: " + id + ", required service: " + newService);
        }
        this.myLifecycleProvider.requiredServiceChanged(id, newService);
        this.checkForModification();
    }

    private boolean validate(String id, Object req) {
        List<ServiceRequirementDescriptor> reqs = this.myLifecycleProvider.getServiceRequirements();
        return req == null && ServiceLifecycleProvider.Validator.validateServiceId(reqs, id) || ServiceLifecycleProvider.Validator.validateService(reqs, id, req);
    }

    private void checkForModification() {
        T service = this.myLifecycleProvider.getService();
        if (service == null && this.myService != null) {
            theLogger.warning("Required Service change stopped this service.  Service is being unregistered.");
            this.unregisterService();
        } else if (service != null && this.myService == null) {
            theLogger.info("Required Service change has started this service.");
            this.myService = service;
            this.registerService();
        } else if (service != this.myService) {
            theLogger.warning("Required Service change has changed this service.");
            ServiceRegistration oldReg = this.myServiceRegistration;
            this.myService = service;
            this.registerService();
            oldReg.unregister();
        }
    }

    protected void registerService() {
        ServiceRegistration reg;
        Properties props = this.myLifecycleProvider.getRegistrationProperties();
        Properties allProps = null;
        if (props != null || this.myRegistrationProperties != null) {
            allProps = new Properties();
            if (props != null) {
                allProps.putAll((Map<?, ?>)props);
            }
            if (this.myRegistrationProperties != null) {
                allProps.putAll((Map<?, ?>)this.myRegistrationProperties);
            }
        }
        this.myServiceRegistration = reg = this.myContext.registerService(this.myRegistrationClassName, this.myService, (Dictionary)allProps);
        theLogger.log(Level.INFO, "Service Successfully Registered: {0}", this.myService.toString());
    }

    class RequirementStatusListener
    implements PropertyChangeListener {
        RequirementStatusListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt == null) {
                return;
            }
            String name = evt.getPropertyName();
            if ("allRequirementsAvailable".equals(name)) {
                this.handleAllAvailable(evt);
            } else {
                if (!DynamicServiceLauncher.this.myInitializedFlag) {
                    return;
                }
                if ("requirementChanged".equals(name)) {
                    String id = evt.getOldValue().toString();
                    Object obj = evt.getNewValue();
                    DynamicServiceLauncher.this.handleChanged(id, obj);
                }
            }
        }

        private boolean handleAllAvailable(PropertyChangeEvent evt) {
            theLogger.info("All requirements available, attempting to create service.");
            Object obj = evt.getNewValue();
            if (obj == null || !(obj instanceof Map)) {
                theLogger.warning("Invalid requirement map, cannot create service.");
                return true;
            }
            try {
                Map reqs = (Map)obj;
                DynamicServiceLauncher.this.handleRequiredServices(reqs);
            }
            catch (ClassCastException ex) {
                theLogger.log(Level.WARNING, "Improper requirement Map type.", ex);
                return true;
            }
            DynamicServiceLauncher.this.myInitializedFlag = true;
            return true;
        }
    }
}

