/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.osgi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public abstract class ServiceClassListener<T>
implements ServiceListener {
    private static final Logger theLogger = Logger.getLogger(ServiceClassListener.class.getName());
    protected List<T> myList;
    private Class<T> myClass;
    protected BundleContext myContext;
    private Map<ServiceReference, T> myReferenceMap;

    public ServiceClassListener(Class<T> clazz, BundleContext context, String serviceFilter) {
        this.myContext = context;
        this.myList = new ArrayList<T>();
        this.myReferenceMap = new HashMap<ServiceReference, T>();
        this.myClass = clazz;
        if (this.myContext != null) {
            String filter = "(objectClass=" + this.myClass.getName() + ")";
            boolean empty = serviceFilter == null || serviceFilter.isEmpty();
            filter = empty ? filter : "(&" + filter + serviceFilter + ")";
            try {
                this.myContext.addServiceListener((ServiceListener)this, filter);
            }
            catch (InvalidSyntaxException ex) {
                theLogger.log(Level.WARNING, "Could not register ServiceListener.  Invalid filter syntax.", ex);
            }
        }
        if (this.myList == null || this.myContext == null) {
            return;
        }
        try {
            ServiceReference[] refs = context.getServiceReferences(this.myClass.getName(), null);
            if (refs == null || refs.length == 0) {
                return;
            }
            for (ServiceReference se : refs) {
                this.addService(se);
            }
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.SEVERE, "There was an error fetching service references.", ex);
        }
    }

    public void serviceChanged(ServiceEvent se) {
        ServiceReference ref = se.getServiceReference();
        switch (se.getType()) {
            case 1: {
                this.addService(ref);
                break;
            }
            case 4: 
            case 8: {
                this.removeService(ref);
            }
        }
    }

    private void addService(ServiceReference ref) {
        T t = this.getService(ref);
        if (t == null) {
            return;
        }
        if (!this.myReferenceMap.containsKey(ref)) {
            this.myList.add(t);
            this.myReferenceMap.put(ref, t);
            this.addService(t);
        }
    }

    protected abstract void addService(T var1);

    private void removeService(ServiceReference ref) {
        T t = this.getService(ref);
        this.myReferenceMap.remove(ref);
        this.myList.remove(t);
        this.removeService(t);
    }

    protected abstract void removeService(T var1);

    private T getService(ServiceReference se) {
        if (se == null || this.myContext == null) {
            return null;
        }
        Object obj = this.myContext.getService(se);
        if (!this.myClass.isInstance(obj)) {
            return null;
        }
        Object t = obj;
        return (T)t;
    }
}

