/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.osgi;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.robokind.api.common.osgi.ServiceRequirementDescriptor;

public interface ServiceLifecycleProvider<T> {
    public void start(Map<String, Object> var1);

    public void requiredServiceChanged(String var1, Object var2);

    public T getService();

    public List<ServiceRequirementDescriptor> getServiceRequirements();

    public Properties getRegistrationProperties();

    public Class<T> getServiceClass();

    public static class Validator {
        private static final Logger theLogger = Logger.getLogger(Validator.class.getName());

        public static boolean validateServices(List<ServiceRequirementDescriptor> descriptors, Map<String, Object> services) {
            for (ServiceRequirementDescriptor descriptor : descriptors) {
                if (Validator.checkDescriptor(descriptor, services)) continue;
                return false;
            }
            return true;
        }

        private static boolean checkDescriptor(ServiceRequirementDescriptor descriptor, Map<String, Object> requirements) {
            String id = descriptor.getRequirementId();
            Object req = requirements.get(id);
            if (req == null) {
                return false;
            }
            Class reqClass = descriptor.getServiceClass();
            return reqClass.isAssignableFrom(req.getClass());
        }

        public static boolean validateService(List<ServiceRequirementDescriptor> descriptors, String requirmentId, Object requirement) {
            if (requirmentId == null || requirement == null) {
                theLogger.warning("Found null argument.  Returning false.");
                return false;
            }
            for (ServiceRequirementDescriptor descriptor : descriptors) {
                String id = descriptor.getRequirementId();
                Class reqClass = descriptor.getServiceClass();
                if (!requirmentId.equals(id) || !reqClass.isAssignableFrom(requirement.getClass())) continue;
                return true;
            }
            return false;
        }

        public static boolean validateServiceId(List<ServiceRequirementDescriptor> descriptors, String requirementId) {
            if (requirementId == null) {
                theLogger.warning("Found null argument.  Returning false.");
                return false;
            }
            for (ServiceRequirementDescriptor descriptor : descriptors) {
                String id = descriptor.getRequirementId();
                if (!requirementId.equals(id)) continue;
                return true;
            }
            return false;
        }
    }
}

