/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.osgi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.osgi.SingleServiceListener;
import org.robokind.api.common.property.PropertyChangeNotifier;

public class ServiceRequirementsTracker
extends PropertyChangeNotifier {
    private static final Logger theLogger = Logger.getLogger(ServiceRequirementsTracker.class.getName());
    public static final String PROP_REQUIREMENT_AVAILABLE = "requirementAvailable";
    public static final String PROP_REQUIREMENT_CHANGED = "requirementChanged";
    public static final String PROP_REQUIREMENT_UNAVAILABLE = "requirementUnavailable";
    public static final String PROP_ALL_REQUIREMENTS_AVAILABLE = "allRequirementsAvailable";
    private BundleContext myContext;
    private List<SingleServiceListener> myRequirementTrackers;
    private Map<String, SingleServiceListener> myRequirementIds;
    private Map<String, Object> myAvailableRequirements;
    private boolean myListeningFlag;

    public ServiceRequirementsTracker(BundleContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myRequirementTrackers = new ArrayList<SingleServiceListener>();
        this.myAvailableRequirements = new HashMap<String, Object>();
        this.myRequirementIds = new HashMap<String, SingleServiceListener>();
        this.myListeningFlag = false;
    }

    public boolean requirementsSatisfied() {
        return this.myAvailableRequirements.size() == this.myRequirementTrackers.size();
    }

    public Map<String, Object> getRequiredServices() {
        if (!this.requirementsSatisfied()) {
            return null;
        }
        return this.myAvailableRequirements;
    }

    public Object getRequiredService(String requirementId) {
        return this.myAvailableRequirements.get(requirementId);
    }

    public void addRequirement(Class clazz, String requirementId, String filterString) {
        if (clazz == null || requirementId == null) {
            throw new NullPointerException();
        }
        if (this.myListeningFlag) {
            throw new IllegalStateException("Unable to add requirement while listening.");
        }
        if (this.myRequirementIds.containsKey(requirementId)) {
            throw new IllegalArgumentException("Unable to add requirement, requirementId already exists.");
        }
        SingleServiceListener ssl = new SingleServiceListener(clazz, this.myContext, filterString);
        ssl.addPropertyChangeListener(new RequirementListener(requirementId));
        this.myRequirementTrackers.add(ssl);
        this.myRequirementIds.put(requirementId, ssl);
    }

    public void start() {
        this.myListeningFlag = true;
        for (SingleServiceListener ssl : this.myRequirementTrackers) {
            ssl.start();
        }
    }

    public void stop() {
        this.myListeningFlag = false;
        this.myAvailableRequirements.clear();
        for (SingleServiceListener ssl : this.myRequirementTrackers) {
            ssl.stop();
        }
    }

    private void requiredServiceFound(String requirementId, Object req) {
        if (requirementId == null || req == null) {
            throw new NullPointerException();
        }
        if (!this.myRequirementIds.containsKey(requirementId)) {
            return;
        }
        theLogger.log(Level.INFO, "Found required service: {0}", requirementId);
        this.myAvailableRequirements.put(requirementId, req);
        this.firePropertyChange(PROP_REQUIREMENT_AVAILABLE, requirementId, req);
        this.checkAllRequirements();
    }

    private void checkAllRequirements() {
        if (!this.requirementsSatisfied()) {
            return;
        }
        theLogger.log(Level.INFO, "All requirements present: {0}", Arrays.toString(this.myRequirementIds.keySet().toArray()));
        this.firePropertyChange(PROP_ALL_REQUIREMENTS_AVAILABLE, null, this.getRequiredServices());
    }

    private void requiredServiceChanged(String requirementId, Object req) {
        if (requirementId == null || req == null) {
            throw new NullPointerException();
        }
        if (!this.myRequirementIds.containsKey(requirementId)) {
            return;
        }
        theLogger.log(Level.INFO, "Required service changed: {0}", requirementId);
        this.myAvailableRequirements.put(requirementId, req);
        this.firePropertyChange(PROP_REQUIREMENT_CHANGED, requirementId, req);
    }

    private void requiredServiceLost(String requirementId) {
        if (requirementId == null) {
            throw new NullPointerException();
        }
        if (!this.myRequirementIds.containsKey(requirementId)) {
            return;
        }
        theLogger.log(Level.INFO, "Lost required service: {0}", requirementId);
        this.myAvailableRequirements.remove(requirementId);
        this.firePropertyChange(PROP_REQUIREMENT_UNAVAILABLE, requirementId, null);
    }

    class RequirementListener
    implements PropertyChangeListener {
        private String myRequirementId;

        public RequirementListener(String requirementId) {
            this.myRequirementId = requirementId;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("serviceTracked".equals(evt.getPropertyName())) {
                this.track(evt.getOldValue(), evt.getNewValue());
            } else if ("serviceRemoved".equals(evt.getPropertyName())) {
                this.untrack(evt.getNewValue());
            }
        }

        private void track(Object oldVal, Object newVal) {
            if (oldVal == null) {
                ServiceRequirementsTracker.this.requiredServiceFound(this.myRequirementId, newVal);
            } else {
                ServiceRequirementsTracker.this.requiredServiceChanged(this.myRequirementId, newVal);
            }
        }

        private void untrack(Object obj) {
            ServiceRequirementsTracker.this.requiredServiceLost(this.myRequirementId);
        }
    }
}

