/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.osgi;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.ServiceClassListener;
import org.robokind.api.common.property.PropertyChangeNotifier;

public class SingleServiceListener<T>
extends PropertyChangeNotifier
implements ServiceListener {
    private static final Logger theLogger = Logger.getLogger(ServiceClassListener.class.getName());
    public static final String PROP_SERVICE_TRACKED = "serviceTracked";
    public static final String PROP_SERVICE_MODIFIED = "serviceModified";
    public static final String PROP_SERVICE_REMOVED = "serviceRemoved";
    private Class<T> myClass;
    private String myFilter;
    private T myTrackedClass;
    private ServiceReference myReference;
    protected BundleContext myContext;
    private List<ServiceReference> myReferences;
    private boolean myStartFlag;

    public SingleServiceListener(Class<T> clazz, BundleContext context, String serviceFilter) {
        if (clazz == null || context == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myReferences = new LinkedList<ServiceReference>();
        this.myClass = clazz;
        this.myFilter = serviceFilter;
        this.myStartFlag = false;
    }

    public ServiceReference getServiceReference() {
        this.ensureTracking();
        return this.myReference;
    }

    public Class<T> getServiceClass() {
        return this.myClass;
    }

    public String getFilterString() {
        return this.myFilter;
    }

    public T getService() {
        if (!this.ensureTracking()) {
            return null;
        }
        return this.myTrackedClass;
    }

    private boolean ensureTracking() {
        if (this.myTrackedClass != null) {
            return true;
        }
        if (this.myReference != null) {
            ServiceReference ref = this.myReference;
            this.myReference = null;
            if (this.track(ref)) {
                return true;
            }
        }
        for (ServiceReference ref : this.myReferences) {
            if (!this.track(ref)) continue;
            return true;
        }
        return false;
    }

    public void releaseService() {
        if (this.myReference != null) {
            this.untrackWithEvent(this.myReference);
        }
    }

    public boolean start() {
        if (this.myContext == null) {
            return false;
        }
        if (this.myStartFlag) {
            return true;
        }
        this.myStartFlag = this.startListening() && this.collectServiceReferences();
        return this.myStartFlag;
    }

    private boolean startListening() {
        String listenerFilter = "(objectClass=" + this.myClass.getName() + ")";
        boolean empty = this.myFilter == null || this.myFilter.isEmpty();
        listenerFilter = empty ? listenerFilter : "(&" + listenerFilter + this.myFilter + ")";
        try {
            this.myContext.addServiceListener((ServiceListener)this, listenerFilter);
            return true;
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Could not register ServiceListener. Invalid filter syntax.", ex);
            return false;
        }
    }

    private boolean collectServiceReferences() {
        ServiceReference[] refs;
        try {
            refs = this.myContext.getServiceReferences(this.myClass.getName(), this.myFilter);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.SEVERE, "There was an error fetching service references.", ex);
            return false;
        }
        if (refs == null) {
            return true;
        }
        for (ServiceReference ref : refs) {
            if (this.myReferences.contains(ref)) continue;
            this.addService(ref);
        }
        return true;
    }

    public void stop() {
        this.stopListening();
        this.releaseService();
        this.myReferences.clear();
    }

    private void stopListening() {
        try {
            this.myContext.removeServiceListener((ServiceListener)this);
        }
        catch (IllegalStateException ex) {
            theLogger.log(Level.WARNING, "BundleContext not valid.", ex);
        }
    }

    public void serviceChanged(ServiceEvent se) {
        ServiceReference ref = se.getServiceReference();
        switch (se.getType()) {
            case 1: {
                this.addService(ref);
                break;
            }
            case 4: 
            case 8: {
                this.removeService(ref);
                break;
            }
            case 2: {
                this.modified(ref);
            }
        }
    }

    private void addService(ServiceReference ref) {
        if (!this.myReferences.contains(ref)) {
            this.myReferences.add(ref);
        }
        if (this.myReference == null) {
            this.track(ref);
        }
    }

    private void removeService(ServiceReference ref) {
        this.myReferences.remove(ref);
        if (this.myReferences.isEmpty()) {
            this.untrackWithEvent(ref);
        } else {
            this.track(this.myReferences.get(0));
        }
    }

    private void modified(ServiceReference ref) {
        if (ref == null || !ref.equals(this.myReference)) {
            return;
        }
        this.firePropertyChange(PROP_SERVICE_MODIFIED, null, this.myTrackedClass);
    }

    private void untrackWithEvent(ServiceReference ref) {
        if (this.myReference == null || !this.myReference.equals(ref)) {
            return;
        }
        try {
            this.myContext.ungetService(this.myReference);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Error ungetting service", ex);
        }
        this.myReference = null;
        T old = this.myTrackedClass;
        this.myTrackedClass = null;
        this.firePropertyChange(PROP_SERVICE_REMOVED, null, old);
    }

    private void untrack(ServiceReference ref) {
        if (this.myReference == null || !this.myReference.equals(ref)) {
            return;
        }
        try {
            this.myContext.ungetService(this.myReference);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Error ungetting service", ex);
        }
        this.myReference = null;
        this.myTrackedClass = null;
    }

    private boolean track(ServiceReference ref) {
        if (ref == null) {
            throw new NullPointerException();
        }
        if (ref.equals(this.myReference)) {
            return true;
        }
        T tracked = OSGiUtils.getService(this.myClass, this.myContext, ref);
        if (tracked == null) {
            return false;
        }
        T old = this.myTrackedClass;
        this.untrack(this.myReference);
        this.myReference = ref;
        this.myTrackedClass = tracked;
        this.firePropertyChange(PROP_SERVICE_TRACKED, old, this.myTrackedClass);
        return true;
    }
}

