/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.position;

import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;

public class NumberRange
implements NormalizableRange<Integer> {
    private int myMin;
    private double myRange;
    private int myAMin;
    private int myAMax;

    public NumberRange(int min, int max) {
        this.myMin = min;
        this.myRange = max - min;
        if (this.myRange == 0.0) {
            throw new IllegalArgumentException("Range cannot be zero.");
        }
        this.myAMin = min < max ? min : max;
        this.myAMax = min > max ? min : max;
    }

    @Override
    public boolean isValid(Integer val) {
        if (val == null) {
            throw new NullPointerException();
        }
        return this.myAMin <= val && val <= this.myAMax;
    }

    @Override
    public NormalizedDouble normalizeValue(Integer val) {
        if (!this.isValid(val)) {
            return null;
        }
        double norm = (double)(val - this.myMin) / this.myRange;
        return new NormalizedDouble(norm);
    }

    @Override
    public Integer denormalizeValue(NormalizedDouble v) {
        return (int)(v.getValue() * this.myRange + (double)this.myMin);
    }
}

