/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.property;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.robokind.api.common.property.PropertyChangeSource;
import org.robokind.api.common.property.PropertyChangeUtils;

public class PropertyChangeNotifier
implements PropertyChangeSource {
    private transient PropertyChangeSupport myPropertyChangeSupport;

    public PropertyChangeNotifier(PropertyChangeSupport support) {
        this.myPropertyChangeSupport = support;
        this.completeInit(this);
    }

    public PropertyChangeNotifier(Object sourceBean) {
        this.completeInit(sourceBean);
    }

    public PropertyChangeNotifier() {
        this.completeInit(this);
    }

    private void completeInit(Object sourceBean) {
        if (this.myPropertyChangeSupport == null) {
            this.myPropertyChangeSupport = PropertyChangeUtils.buildPropertyChangeSupport(sourceBean);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myPropertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.myPropertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.myPropertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        this.myPropertyChangeSupport.firePropertyChange(evt);
    }

    protected void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.myPropertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    protected void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        this.myPropertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    protected void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        this.myPropertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }
}

