/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.services;

import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ServiceConfigurationLoader;
import org.robokind.api.common.services.ServiceFactory;

public class ServiceContext<ServiceClass, ServiceConfig, Param> {
    private ServiceConfigurationLoader<ServiceConfig, Param> myLoader;
    private ServiceFactory<ServiceClass, ServiceConfig> myFactory;
    private Param myLoadParameter;
    private ServiceConfig myConfig;
    private ServiceClass myService;

    public ServiceContext() {
    }

    public ServiceContext(ServiceConfigurationLoader<ServiceConfig, Param> loader, ServiceFactory<ServiceClass, ServiceConfig> connector) {
        if (loader == null || connector == null) {
            throw new NullPointerException();
        }
        this.myLoader = loader;
        this.myFactory = connector;
    }

    public ServiceConfigurationLoader<ServiceConfig, Param> getServiceConfigurationLoader() {
        return this.myLoader;
    }

    public void setServiceConfigurationLoader(ServiceConfigurationLoader<ServiceConfig, Param> loader) {
        this.myLoader = loader;
    }

    public ServiceFactory<ServiceClass, ServiceConfig> getServiceFactory() {
        return this.myFactory;
    }

    public void setServiceConnector(ServiceFactory<ServiceClass, ServiceConfig> factory) {
        this.myFactory = factory;
    }

    public Param getLoadParameter() {
        return this.myLoadParameter;
    }

    public void setLoadParameter(Param param) {
        this.myLoadParameter = param;
    }

    public boolean loadConfiguration() throws Exception {
        if (this.myConfig != null) {
            return true;
        }
        if (this.myLoader == null) {
            throw new NullPointerException();
        }
        this.myConfig = this.myLoader.loadConfiguration(this.myLoadParameter);
        return this.myConfig != null;
    }

    public ServiceConfig getServiceConfiguration() {
        return this.myConfig;
    }

    public boolean buildService() throws Exception {
        if (this.myService != null) {
            return true;
        }
        if (this.myFactory == null) {
            return false;
        }
        if (this.myConfig == null) {
            this.loadConfiguration();
            if (this.myConfig == null) {
                return false;
            }
        }
        this.myService = this.myFactory.build(this.myConfig);
        return this.myService != null;
    }

    public ServiceClass getService() {
        return this.myService;
    }

    public VersionProperty getServiceVersion() {
        return this.myFactory.getServiceVersion();
    }

    public Class<ServiceClass> getServiceClass() {
        return this.myFactory.getServiceClass();
    }

    public VersionProperty getConfigFormat() {
        return this.myLoader.getConfigurationFormat();
    }

    public Class<ServiceConfig> getConfigClass() {
        return this.myLoader.getConfigurationClass();
    }
}

