/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.services;

import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.SingleServiceListener;
import org.robokind.api.common.services.ServiceConfigurationLoader;
import org.robokind.api.common.services.ServiceConfigurationWriter;
import org.robokind.api.common.services.ServiceFactory;

public class ServiceUtils {
    private static final Logger theLogger = Logger.getLogger(ServiceUtils.class.getName());

    public static ServiceRegistration registerServiceFactory(BundleContext context, ServiceFactory fact, Properties props) {
        if (context == null || fact == null) {
            throw new NullPointerException();
        }
        if (props == null) {
            props = new Properties();
        }
        props.put("ServiceVersion", fact.getServiceVersion().toString());
        props.put("ServiceClass", fact.getServiceClass().getName());
        ServiceRegistration reg = context.registerService(ServiceFactory.class.getName(), (Object)fact, (Dictionary)props);
        if (reg == null) {
            theLogger.log(Level.WARNING, "Unknown error occured while registering ServiceFactory.");
        } else {
            theLogger.log(Level.INFO, "ServiceFactory registered successfully.");
        }
        return reg;
    }

    public static ServiceRegistration registerConfigurationLoader(BundleContext context, ServiceConfigurationLoader loader, Properties props) {
        if (context == null || loader == null) {
            throw new NullPointerException();
        }
        if (props == null) {
            props = new Properties();
        }
        props.put("ConfigurationFormatVersion", loader.getConfigurationFormat().toString());
        props.put("ServiceConfigurationClass", loader.getConfigurationClass().getName());
        props.put("ServiceConfigParameterClass", loader.getParameterClass().getName());
        ServiceRegistration reg = context.registerService(ServiceConfigurationLoader.class.getName(), (Object)loader, (Dictionary)props);
        if (reg == null) {
            theLogger.log(Level.WARNING, "Unknown error occured while registering ServiceConfigurationLoader.");
        } else {
            theLogger.log(Level.INFO, "ServiceConfigurationLoader registered successfully.");
        }
        return reg;
    }

    public static ServiceRegistration registerConfigurationWriter(BundleContext context, ServiceConfigurationWriter writer, Properties props) {
        if (context == null || writer == null) {
            throw new NullPointerException();
        }
        if (props == null) {
            props = new Properties();
        }
        props.put("ConfigurationFormatVersion", writer.getConfigurationFormat().toString());
        props.put("ServiceConfigurationClass", writer.getConfigurationClass().getName());
        props.put("ServiceConfigParameterClass", writer.getParameterClass().getName());
        ServiceRegistration reg = context.registerService(ServiceConfigurationWriter.class.getName(), (Object)writer, (Dictionary)props);
        if (reg == null) {
            theLogger.log(Level.WARNING, "Unknown error occured while registering ServiceConfigurationWriter.");
        } else {
            theLogger.log(Level.INFO, "ServiceConfigurationWriter registered successfully.");
        }
        return reg;
    }

    public static <Conf, Param> SingleServiceListener<ServiceConfigurationWriter<Conf, Param>> createWriterServiceListener(BundleContext context, Class<Conf> configClass, Class<Param> paramClass, VersionProperty configFormat, String serviceFilter) {
        Properties props = new Properties();
        props.put("ConfigurationFormatVersion", configFormat.toString());
        props.put("ServiceConfigurationClass", configClass.getName());
        props.put("ServiceConfigParameterClass", paramClass.getName());
        String writerFilter = OSGiUtils.createServiceFilter(props);
        if (serviceFilter != null && !serviceFilter.isEmpty()) {
            writerFilter = "(&" + writerFilter + "(" + serviceFilter + "))";
        }
        return new SingleServiceListener<ServiceConfigurationWriter<Conf, Param>>(ServiceConfigurationWriter.class, context, serviceFilter);
    }
}

