/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.triggering;

import java.util.Dictionary;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.triggering.Trigger;
import org.robokind.api.common.triggering.TriggerSequence;
import org.robokind.api.common.utils.TimeUtils;

public class DefaultTriggerSequence
implements TriggerSequence {
    private static final Logger theLogger = Logger.getLogger(DefaultTriggerSequence.class.getName());
    private BundleContext myContext;
    private SortedSet<TriggerSequence.SequencedTrigger> myTriggers;
    private Properties myProperties;
    private boolean myExecutingFlag;
    private ScheduledTriggerExecutor myExecutor;
    private Thread.UncaughtExceptionHandler myExceptionHandler;

    public DefaultTriggerSequence(BundleContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.myTriggers = new TreeSet<TriggerSequence.SequencedTrigger>();
        this.myExecutingFlag = false;
        this.myContext = context;
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.myExceptionHandler = handler;
    }

    public void addTrigger(long triggerDelayMillisec, Trigger trigger) {
        if (this.myExecutingFlag) {
            throw new IllegalStateException("Cannot add Trigger while running.");
        }
        if (trigger == null) {
            throw new NullPointerException();
        }
        this.myTriggers.add(new TriggerSequence.SequencedTrigger(triggerDelayMillisec, trigger));
    }

    @Override
    public SortedSet<TriggerSequence.SequencedTrigger> getTriggers() {
        return this.myTriggers;
    }

    @Override
    public void start() {
        if (this.myExecutingFlag) {
            return;
        }
        this.myExecutingFlag = true;
        this.myExecutor = new ScheduledTriggerExecutor();
        this.myExecutor.start();
    }

    @Override
    public void stop() {
        this.myExecutor.stop();
        this.myExecutingFlag = false;
    }

    class TriggerTask
    implements Callable<ServiceRegistration> {
        private Trigger myTrigger;
        private Properties myRegistrationProperties;

        public TriggerTask(Trigger trigger, Properties registrationProperties) {
            this.myTrigger = trigger;
            this.myRegistrationProperties = registrationProperties;
        }

        @Override
        public ServiceRegistration call() {
            try {
                theLogger.log(Level.INFO, "Registering trigger.  type: {0}, trigger: {1}.", new Object[]{this.myTrigger.getTriggerType(), this.myTrigger});
                this.myTrigger.setTimestampMillisecUTC(TimeUtils.now());
                return DefaultTriggerSequence.this.myContext.registerService(Trigger.class.getName(), (Object)this.myTrigger, (Dictionary)this.myRegistrationProperties);
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "Caught exception in executor.", ex);
                return null;
            }
        }
    }

    class ScheduledTriggerExecutor {
        private ScheduledExecutorService myExecutor;

        ScheduledTriggerExecutor() {
        }

        void start() {
            this.myExecutor = new ScheduledThreadPoolExecutor(1);
            for (TriggerSequence.SequencedTrigger trigger : DefaultTriggerSequence.this.myTriggers) {
                TriggerTask task = new TriggerTask(trigger.getTrigger(), DefaultTriggerSequence.this.myProperties);
                this.myExecutor.schedule(task, trigger.getTriggerTimeMillisec(), TimeUnit.MILLISECONDS);
            }
        }

        void stop() {
            try {
                this.myExecutor.shutdownNow();
                this.myExecutor = null;
            }
            catch (SecurityException ex) {
                theLogger.log(Level.WARNING, "Exception caught while stopping TriggerSequence.", ex);
            }
        }
    }
}

