/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.triggering;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.triggering.Trigger;
import org.robokind.api.common.triggering.TriggerHandler;
import org.robokind.api.common.triggering.TriggerUtils;

public class OSGiTriggeringService {
    private static final Logger theLogger = Logger.getLogger(OSGiTriggeringService.class.getName());
    private BundleContext myContext;
    private OSGiTriggerListener myListener;

    public OSGiTriggeringService(BundleContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myListener = new OSGiTriggerListener();
        try {
            OSGiUtils.addServiceListener(this.myContext, this.myListener, Trigger.class, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void triggerEvent(Trigger trigger) {
        theLogger.log(Level.WARNING, "Triggering event.  type: {0}, filter: {1}.", new Object[]{trigger.getTriggerType(), trigger.getTypeFilter()});
        ServiceReference[] refs = TriggerUtils.findHandlers(this.myContext, trigger);
        if (refs != null) {
            for (ServiceReference ref : refs) {
                if (!this.triggerEvent(ref, trigger)) continue;
                return;
            }
        }
        theLogger.log(Level.WARNING, "Unable to trigger event, no handler available.  type: {0}, filter: {1}.", new Object[]{trigger.getTriggerType(), trigger.getTypeFilter()});
    }

    private boolean triggerEvent(ServiceReference ref, Trigger trigger) {
        TriggerHandler handler = OSGiUtils.getService(TriggerHandler.class, this.myContext, ref);
        if (handler == null) {
            return false;
        }
        handler.handleTrigger(trigger);
        this.myContext.ungetService(ref);
        return true;
    }

    class OSGiTriggerListener
    implements ServiceListener {
        OSGiTriggerListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (1 != event.getType()) {
                return;
            }
            theLogger.info("Received Trigger ServiceEvent.");
            ServiceReference ref = event.getServiceReference();
            Trigger trigger = OSGiUtils.getService(Trigger.class, OSGiTriggeringService.this.myContext, ref);
            if (trigger == null) {
                theLogger.warning("Could not retrieve Trigger from ServiceReference.");
                return;
            }
            OSGiTriggeringService.this.triggerEvent(trigger);
        }
    }
}

