/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.triggering;

import java.util.SortedSet;
import org.robokind.api.common.triggering.Trigger;

public interface TriggerSequence {
    public SortedSet<SequencedTrigger> getTriggers();

    public void start();

    public void stop();

    public static class SequencedTrigger
    implements Comparable<SequencedTrigger> {
        private long myTriggerTimeMillisec;
        private Trigger myTrigger;

        public SequencedTrigger(long triggerTimeMillisec, Trigger trigger) {
            if (trigger == null) {
                throw new NullPointerException();
            }
            if (triggerTimeMillisec < 0L) {
                throw new IllegalArgumentException("Trigger time must be non-negative.  Found: " + triggerTimeMillisec + " for trigger: " + trigger);
            }
            this.myTriggerTimeMillisec = triggerTimeMillisec;
            this.myTrigger = trigger;
        }

        @Override
        public int compareTo(SequencedTrigger o) {
            if (o == null) {
                return 1;
            }
            if (this == o) {
                return 0;
            }
            int cmp = (int)(this.myTriggerTimeMillisec - o.myTriggerTimeMillisec);
            if (cmp == 0 && (cmp = this.toString().compareTo(o.toString())) == 0) {
                return 1;
            }
            return cmp;
        }

        public long getTriggerTimeMillisec() {
            return this.myTriggerTimeMillisec;
        }

        public Trigger getTrigger() {
            return this.myTrigger;
        }
    }
}

