/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.triggering;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.triggering.Trigger;
import org.robokind.api.common.triggering.TriggerHandler;

public class TriggerUtils {
    private static final Logger theLogger = Logger.getLogger(TriggerUtils.class.getName());

    public static ServiceRegistration registerTriggerHandler(BundleContext context, TriggerHandler handler, Properties props) {
        if (context == null || handler == null) {
            throw new NullPointerException();
        }
        return OSGiUtils.registerService(context, TriggerHandler.class.getName(), "triggerType", handler.getTriggerType(), handler, props);
    }

    public static ServiceReference[] findHandlers(BundleContext context, Trigger trigger) {
        return TriggerUtils.findHandlers(context, trigger.getTriggerType(), trigger.getTypeFilter());
    }

    public static ServiceReference[] findHandlers(BundleContext context, String triggerType, String filter) {
        ServiceReference[] refs;
        if (context == null || triggerType == null) {
            throw new NullPointerException();
        }
        String combinedFilter = OSGiUtils.createIdFilter("triggerType", triggerType, filter);
        try {
            refs = context.getServiceReferences(TriggerHandler.class.getName(), combinedFilter);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Error finding TriggerHandler, invalid filter: " + combinedFilter + ".", ex);
            return null;
        }
        if (refs == null) {
            theLogger.log(Level.WARNING, "Could not find TriggerHandler matching filter: {0}.", combinedFilter);
        }
        return refs;
    }
}

