/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.utils;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Utils {
    private static final Logger theLogger = Logger.getLogger(Utils.class.getName());

    public static String bytesToString(byte[] bytes) {
        String ret = "";
        for (byte b : bytes) {
            ret = ret + (char)b;
        }
        return ret;
    }

    public static <K, V> void mergeMaps(Map<K, V> dest, Map<K, V> ... srcs) {
        for (Map<K, V> src : srcs) {
            for (Map.Entry<K, V> e : src.entrySet()) {
                if (dest.containsKey(e.getKey())) continue;
                dest.put(e.getKey(), e.getValue());
            }
        }
    }

    public static int unsign(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }

    public static byte checksum(byte[] data, int offset, int len, boolean invert, byte ... extra) {
        int chk = 0;
        for (int i = offset; i < len; ++i) {
            chk += data[i];
        }
        for (byte b : extra) {
            chk += b;
        }
        if (invert) {
            return (byte)(~chk & 0xFF);
        }
        return (byte)chk;
    }

    public static double bound(double n, double low, double high) {
        return Math.max(low, Math.min(n, high));
    }

    public static long bound(long n, long low, long high) {
        return Math.max(low, Math.min(n, high));
    }

    public static int bound(int n, int low, int high) {
        return Math.max(low, Math.min(n, high));
    }

    public static int readHex(String xx) {
        int high = Utils.readHex(xx.charAt(0));
        int low = Utils.readHex(xx.charAt(1));
        return (high *= 16) + low;
    }

    public static int readHex(char c) {
        int a = c;
        if (a >= 97) {
            a = a - 97 + 10;
        } else if (a >= 65) {
            a = a - 65 + 10;
        } else if (a >= 48) {
            a -= 48;
        }
        return a;
    }

    public static byte[] convertToByteArray(List<Byte> a) {
        byte[] b = new byte[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            b[i] = a.get(i);
        }
        return b;
    }
}

