/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.api.common.position;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public interface NormalizableRange<T> {
    /**
     * Returns true if t is within the NormalizableRange.
     * @param t value to check
     * @return true if t is within the NormalizableRange
     */
    public boolean isValid(T t);
    /**
     * Normalizes a value within the NormalizableRange.
     * @param t value to normalize
     * @return value within the NormalizableRange, null if t is out of range
     */
    public NormalizedDouble normalizeValue(T t);
    /**
     * Denormalizes a NormalizedDouble to a value within this NormalizableRange.
     * @param v value to denormalize
     * @return non-normalized value within the NormalizableRange
     */
    public T denormalizeValue(NormalizedDouble v);
    
}
