/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.common.triggering;

import java.util.Properties;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class DefaultTrigger implements Trigger{
    private String myTriggerType;
    private String myTypeFilter;
    private Properties myTriggerProperties;
    private long myTimestamp;

    public DefaultTrigger(String triggerType, String typeFilter, 
            Properties triggerProperties){
        if(triggerType == null){
            throw new NullPointerException();
        }
        myTriggerType = triggerType;
        myTypeFilter = typeFilter;
        myTriggerProperties = triggerProperties;
    }
    
    @Override
    public String getTriggerType() {
        return myTriggerType;
    }

    @Override
    public String getTypeFilter() {
        return myTypeFilter;
    }

    @Override
    public Properties getTriggerProperties() {
        return myTriggerProperties;
    }

    @Override
    public long getTimestampMillisecUTC() {
        return myTimestamp;
    }

    @Override
    public void setTimestampMillisecUTC(long time) {
        myTimestamp = time;
    }
    
}
