/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.common.triggering;

import java.util.SortedSet;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public interface TriggerSequence {
    public SortedSet<SequencedTrigger> getTriggers();
    public void start();
    public void stop();
    
    public class SequencedTrigger implements Comparable<SequencedTrigger> {
        private long myTriggerTimeMillisec;
        private Trigger myTrigger;
        
        public SequencedTrigger(long triggerTimeMillisec, Trigger trigger){
            if(trigger == null){
                throw new NullPointerException();
            }else if(triggerTimeMillisec < 0){
                throw new IllegalArgumentException(
                        "Trigger time must be non-negative.  Found: " + 
                        triggerTimeMillisec + " for trigger: " + trigger);
            }
            myTriggerTimeMillisec = triggerTimeMillisec;
            myTrigger = trigger;
        }

        @Override
        public int compareTo(SequencedTrigger o) {
            if(o == null){
                return 1;
            }else if(this == o){
                return 0;
                
            }
            int cmp = (int)(myTriggerTimeMillisec - o.myTriggerTimeMillisec);
            if(cmp == 0){
                cmp = toString().compareTo(o.toString());
                if(cmp == 0){
                    return 1;
                }
            }
            return cmp;
        }
        
        public long getTriggerTimeMillisec(){
            return myTriggerTimeMillisec;
        }
        
        public Trigger getTrigger(){
            return myTrigger;
        }
    }
}
