/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.common.utils;

/**
 * Converts and instance of type A to a new instance of type B.
 * Adapter is used in the Messaging system for serialization.
 * @author Matthew Stevenson <www.robokind.org>
 * 
 * @param <A> type to adapt from
 * @param <B> type to adapt to
 */
public interface Adapter<A,B> {
    /**
     * Adapts the given instance.
     * @param a instance to adapt
     * @return an instance of B from the given instance of A.
     */
    public B adapt(A a);
}
