/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.api.common.utils;

/**
 * Defines a generic interface for a class that is able to create an object of a
 * given type from an unparameterized call.
 * @param <T> Type created by the Factory
 * 
 * @author Matthew Stevenson <www.robokind.org>
 */
public interface Factory<T> {
    /**
     * Creates and returns an object of the given type.
     * @return a new object of the given type
     */
    public T create();
}
