/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.osgi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.robokind.api.common.property.PropertyChangeNotifier;

public class ServiceClassListener<T>
extends PropertyChangeNotifier
implements ServiceListener {
    private static final Logger theLogger = Logger.getLogger(ServiceClassListener.class.getName());
    public static final String PROP_SERVICE_ADDED = "serviceAdded";
    public static final String PROP_SERVICE_REMOVED = "serviceRemoved";
    private Class<T> myClass;
    private BundleContext myContext;
    private Map<ServiceReference, T> myReferenceMap;
    private List<ServiceReference> myReferences;
    private String myFilter;

    public ServiceClassListener(Class<T> clazz, BundleContext context, String serviceFilter) {
        if (clazz == null || context == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myReferenceMap = new HashMap<ServiceReference, T>();
        this.myClass = clazz;
        String filter = "(objectClass=" + this.myClass.getName() + ")";
        boolean empty = serviceFilter == null || serviceFilter.isEmpty();
        this.myFilter = empty ? filter : "(&" + filter + serviceFilter + ")";
    }

    public void start() {
        try {
            this.myContext.addServiceListener((ServiceListener)this, this.myFilter);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Could not register ServiceListener.  Invalid filter syntax.", ex);
        }
        this.myReferences = new ArrayList<ServiceReference>();
        try {
            ServiceReference[] refs = this.myContext.getServiceReferences(this.myClass.getName(), null);
            if (refs == null || refs.length == 0) {
                return;
            }
            for (ServiceReference se : refs) {
                this.addService(se);
            }
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.SEVERE, "There was an error fetching service references.", ex);
        }
    }

    public void serviceChanged(ServiceEvent se) {
        ServiceReference ref = se.getServiceReference();
        switch (se.getType()) {
            case 1: {
                this.addService(ref);
                break;
            }
            case 4: 
            case 8: {
                this.removeService(ref);
            }
        }
    }

    private void addService(ServiceReference ref) {
        T t = this.getService(ref);
        if (t == null) {
            return;
        }
        if (!this.myReferenceMap.containsKey(ref)) {
            this.myReferenceMap.put(ref, t);
            this.myReferences.add(ref);
            this.addService(t);
            this.firePropertyChange(PROP_SERVICE_ADDED, null, t);
        }
    }

    protected void addService(T t) {
    }

    private void removeService(ServiceReference ref) {
        T t = this.myReferenceMap.remove(ref);
        this.myReferences.remove(ref);
        if (t == null) {
            return;
        }
        this.removeService(t);
        this.myContext.ungetService(ref);
        this.firePropertyChange(PROP_SERVICE_REMOVED, null, t);
    }

    protected void removeService(T t) {
    }

    public List<ServiceReference> getServiceReferences() {
        return this.myReferences;
    }

    private T getService(ServiceReference se) {
        if (se == null || this.myContext == null) {
            return null;
        }
        Object obj = this.myContext.getService(se);
        if (!this.myClass.isInstance(obj)) {
            return null;
        }
        Object t = obj;
        return (T)t;
    }

    public T getTopService() {
        if (this.myReferences.isEmpty()) {
            return null;
        }
        return this.myReferenceMap.get(this.myReferences.get(0));
    }
}

