/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.osgi.lifecycle;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.robokind.api.common.lifecycle.utils.DescriptorBuilder;
import org.robokind.api.common.osgi.lifecycle.ConfiguredServiceParams;
import org.robokind.api.common.services.ConfigurationLoader;
import org.robokind.api.common.services.ServiceContext;
import org.robokind.api.common.services.ServiceFactory;

public class ConfiguredServiceLifecycle<T, C, P>
extends AbstractLifecycleProvider<T, T> {
    private static final Logger theLogger = Logger.getLogger(ConfiguredServiceLifecycle.class.getName());
    private static final String theServiceFactory = "serviceFactory";
    private static final String theConfigLoader = "configLoader";
    private static final String theLoaderParam = "loaderParam";
    private Class<T> myServiceClass;
    private P myParam;
    private C myConfig;
    protected ServiceContext<T, C, P> myServiceContext;

    public ConfiguredServiceLifecycle(ConfiguredServiceParams<T, C, P> params) {
        super(new ArrayList<DependencyDescriptor>());
        this.myServiceClass = params.getServiceClass();
        this.myConfig = params.getConfig();
        this.myParam = params.getParam();
        this.getDependencyDescriptors().add(this.buildFactoryDescriptor(this.myServiceClass, params.getConfigClass(), params.getServiceVersion()));
        if (params.getConfig() == null) {
            this.getDependencyDescriptors().add(this.buildLoaderDescriptor(params.getConfigClass(), params.getParamClass(), params.getConfigFormat()));
        }
        if (params.getParam() == null && this.myConfig == null) {
            this.getDependencyDescriptors().add(this.buildParamDescriptor(params.getParamClass(), params.getConfigFormat(), params.getParamId()));
        }
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("ServiceVersion", params.getServiceVersion().toString());
    }

    private DependencyDescriptor buildFactoryDescriptor(Class<T> serviceClass, Class<C> configClass, VersionProperty serviceVersion) {
        DescriptorBuilder descs = new DescriptorBuilder(theServiceFactory, ServiceFactory.class).with("serviceClass", serviceClass.getName()).with("ServiceVersion", serviceVersion.toString());
        if (configClass != null) {
            descs.with("configClass", configClass.getName());
        }
        return descs.getDescriptor();
    }

    private DependencyDescriptor buildLoaderDescriptor(Class<C> configClass, Class<P> paramClass, VersionProperty configFormat) {
        DescriptorBuilder descs = new DescriptorBuilder(theConfigLoader, ConfigurationLoader.class).with("configFormatVersion", configFormat.toString());
        if (configClass != null) {
            descs.with("configClass", configClass.getName());
        }
        if (paramClass != null) {
            descs.with("configParamClass", paramClass.getName());
        }
        return descs.getDescriptor();
    }

    private DependencyDescriptor buildParamDescriptor(Class<P> paramClass, VersionProperty configFormat, String paramId) {
        DescriptorBuilder descs = new DescriptorBuilder(theLoaderParam, paramClass).with("configFormatVersion", configFormat.toString());
        if (paramId != null) {
            descs.with("configParamId", paramId);
        }
        return descs.getDescriptor();
    }

    @Override
    public T getService() {
        return (T)this.myService;
    }

    @Override
    protected T create(Map<String, Object> dependencies) {
        ServiceFactory fact = (ServiceFactory)dependencies.get(theServiceFactory);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setServiceFactory(fact);
        Object param = this.myParam;
        C config = this.myConfig;
        if (this.myConfig == null) {
            ConfigurationLoader loader = (ConfigurationLoader)dependencies.get(theConfigLoader);
            if (this.myParam == null) {
                param = dependencies.get(theLoaderParam);
            }
            serviceContext.setServiceConfigurationLoader(loader);
            serviceContext.setLoadParameter(param);
            if (!serviceContext.loadConfiguration()) {
                theLogger.warning("Failed to load config.");
                return null;
            }
        } else {
            serviceContext.setServiceConfiguration(config);
        }
        if (!serviceContext.buildService()) {
            theLogger.warning("Failed to build service.");
            return null;
        }
        this.myServiceContext = serviceContext;
        return this.myServiceContext.getService();
    }

    @Override
    public synchronized void stop() {
        this.cleanupService(this.myService);
        super.stop();
    }

    @Override
    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (this.myService == null) {
            return;
        }
        if (theLoaderParam.equals(name)) {
            this.cleanupService(this.myService);
            this.myService = null;
            if (this.isSatisfied()) {
                this.myService = this.create(availableDependencies);
            }
            return;
        }
    }

    protected void cleanupService(T service) {
    }

    @Override
    public Class<T> getServiceClass() {
        return this.myServiceClass;
    }
}

