/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.services;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ConfigurationLoader;
import org.robokind.api.common.services.ServiceFactory;

public class ServiceContext<ServiceClass, ServiceConfig, Param> {
    private static final Logger theLogger = Logger.getLogger(ServiceContext.class.getName());
    private ConfigurationLoader<ServiceConfig, Param> myLoader;
    private ServiceFactory<ServiceClass, ServiceConfig> myFactory;
    private Param myLoadParameter;
    private ServiceConfig myConfig;
    private ServiceClass myService;

    public ServiceContext() {
    }

    public ServiceContext(ConfigurationLoader<ServiceConfig, Param> loader, ServiceFactory<ServiceClass, ServiceConfig> factory) {
        if (loader == null || factory == null) {
            throw new NullPointerException();
        }
        this.myLoader = loader;
        this.myFactory = factory;
    }

    public ConfigurationLoader<ServiceConfig, Param> getServiceConfigurationLoader() {
        return this.myLoader;
    }

    public void setServiceConfigurationLoader(ConfigurationLoader<ServiceConfig, Param> loader) {
        this.myLoader = loader;
    }

    public ServiceFactory<ServiceClass, ServiceConfig> getServiceFactory() {
        return this.myFactory;
    }

    public void setServiceFactory(ServiceFactory<ServiceClass, ServiceConfig> factory) {
        this.myFactory = factory;
    }

    public Param getLoadParameter() {
        return this.myLoadParameter;
    }

    public void setLoadParameter(Param param) {
        this.myLoadParameter = param;
    }

    public boolean loadConfiguration() {
        if (this.myConfig != null) {
            return true;
        }
        if (this.myLoader == null || this.myLoadParameter == null) {
            return false;
        }
        try {
            this.myConfig = this.myLoader.loadConfiguration(this.myLoadParameter);
        }
        catch (Exception ex) {
            String msg = String.format("There was an error loading the configuration.\nConfig class: %s,\nConfig format: %s,\nLoader class: %s,\nParam class: %s", this.myLoader.getConfigurationClass(), this.myLoader.getConfigurationFormat(), this.myLoader.getClass(), this.myLoader.getParameterClass());
            theLogger.log(Level.WARNING, msg, ex);
        }
        return this.myConfig != null;
    }

    public ServiceConfig getServiceConfiguration() {
        return this.myConfig;
    }

    public void setServiceConfiguration(ServiceConfig config) {
        this.myConfig = config;
    }

    public boolean buildService() {
        if (this.myService != null) {
            return true;
        }
        if (this.myFactory == null) {
            return false;
        }
        if (this.myConfig == null) {
            this.loadConfiguration();
            if (this.myConfig == null) {
                return false;
            }
        }
        try {
            this.myService = this.myFactory.build(this.myConfig);
        }
        catch (Exception ex) {
            String msg = String.format("There was an error loading the configuration.\nService class: %s,\nService version: %s,\nFactory class: %s,\nConfig class: %s.", this.myFactory.getServiceClass(), this.myFactory.getServiceVersion(), this.myFactory.getClass(), this.myFactory.getConfigurationClass());
            theLogger.log(Level.WARNING, msg, ex);
        }
        return this.myService != null;
    }

    public ServiceClass getService() {
        return this.myService;
    }

    public VersionProperty getServiceVersion() {
        return this.myFactory.getServiceVersion();
    }

    public Class<ServiceClass> getServiceClass() {
        return this.myFactory.getServiceClass();
    }

    public VersionProperty getConfigFormat() {
        if (this.myLoader == null) {
            return null;
        }
        return this.myLoader.getConfigurationFormat();
    }

    public Class<ServiceConfig> getConfigurationClass() {
        return this.myFactory.getConfigurationClass();
    }
}

