/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.services;

import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.SingleServiceListener;
import org.robokind.api.common.services.ConfigurationLoader;
import org.robokind.api.common.services.ConfigurationWriter;
import org.robokind.api.common.services.ServiceFactory;

public class ServiceUtils {
    private static final Logger theLogger = Logger.getLogger(ServiceUtils.class.getName());

    public static ServiceRegistration registerFactory(BundleContext context, ServiceFactory fact) {
        return ServiceUtils.registerFactory(context, fact, null);
    }

    public static ServiceRegistration registerFactory(BundleContext context, ServiceFactory fact, Properties props) {
        if (context == null || fact == null) {
            throw new NullPointerException();
        }
        if (props == null) {
            props = new Properties();
        }
        props.put("ServiceVersion", fact.getServiceVersion().toString());
        props.put("serviceClass", fact.getServiceClass().getName());
        props.put("configClass", fact.getConfigurationClass().getName());
        ServiceRegistration reg = context.registerService(ServiceFactory.class.getName(), (Object)fact, (Dictionary)props);
        if (reg == null) {
            theLogger.log(Level.WARNING, "Unknown error occured while registering ServiceFactory.");
        } else {
            theLogger.log(Level.INFO, "ServiceFactory registered successfully: {0}", fact);
        }
        return reg;
    }

    public static ServiceRegistration registerConfigLoader(BundleContext context, ConfigurationLoader loader) {
        return ServiceUtils.registerConfigLoader(context, loader, null);
    }

    public static ServiceRegistration registerConfigLoader(BundleContext context, ConfigurationLoader loader, Properties props) {
        if (context == null || loader == null) {
            throw new NullPointerException();
        }
        if (props == null) {
            props = new Properties();
        }
        props.put("configFormatVersion", loader.getConfigurationFormat().toString());
        props.put("configClass", loader.getConfigurationClass().getName());
        props.put("configParamClass", loader.getParameterClass().getName());
        ServiceRegistration reg = context.registerService(ConfigurationLoader.class.getName(), (Object)loader, (Dictionary)props);
        if (reg == null) {
            theLogger.log(Level.WARNING, "Unknown error occured while registering ServiceConfigurationLoader.");
        } else {
            theLogger.log(Level.INFO, "ServiceConfigurationLoader registered successfully.");
        }
        return reg;
    }

    public static ServiceRegistration registerConfigWriter(BundleContext context, ConfigurationWriter writer) {
        return ServiceUtils.registerConfigWriter(context, writer, null);
    }

    public static ServiceRegistration registerConfigWriter(BundleContext context, ConfigurationWriter writer, Properties props) {
        if (context == null || writer == null) {
            throw new NullPointerException();
        }
        if (props == null) {
            props = new Properties();
        }
        props.put("configFormatVersion", writer.getConfigurationFormat().toString());
        props.put("configClass", writer.getConfigurationClass().getName());
        props.put("configParamClass", writer.getParameterClass().getName());
        ServiceRegistration reg = context.registerService(ConfigurationWriter.class.getName(), (Object)writer, (Dictionary)props);
        if (reg == null) {
            theLogger.log(Level.WARNING, "Unknown error occured while registering ServiceConfigurationWriter.");
        } else {
            theLogger.log(Level.INFO, "ServiceConfigurationWriter registered successfully.");
        }
        return reg;
    }

    public static <Conf, Param> SingleServiceListener<ConfigurationWriter<Conf, Param>> createWriterServiceListener(BundleContext context, Class<Conf> configClass, Class<Param> paramClass, VersionProperty configFormat, String serviceFilter) {
        Properties props = new Properties();
        props.put("configFormatVersion", configFormat.toString());
        props.put("configClass", configClass.getName());
        props.put("configParamClass", paramClass.getName());
        String writerFilter = OSGiUtils.createServiceFilter(props);
        if (serviceFilter != null && !serviceFilter.isEmpty()) {
            writerFilter = "(&" + writerFilter + "(" + serviceFilter + "))";
        }
        return new SingleServiceListener<ConfigurationWriter<Conf, Param>>(ConfigurationWriter.class, context, serviceFilter);
    }
}

