/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.util.Adapter;

public class PolymorphicAdapter<A, B>
implements Adapter<A, B> {
    private static final Logger theLogger = Logger.getLogger(PolymorphicAdapter.class.getName());
    private Map<String, Adapter<A, B>> myAdapterMap;
    private AdapterKeyMap<A> myKeyMap;

    public PolymorphicAdapter(AdapterKeyMap<A> keyMap) {
        if (keyMap == null) {
            throw new NullPointerException();
        }
        this.myKeyMap = keyMap;
        this.myAdapterMap = new HashMap<String, Adapter<A, B>>();
    }

    public void addAdapter(String adaptClass, Adapter<A, B> adapter) {
        if (adaptClass == null || adapter == null) {
            throw new NullPointerException();
        }
        this.myAdapterMap.put(adaptClass, adapter);
    }

    public B adapt(A a) {
        return this.polymorphicAdapt(a);
    }

    private <C extends A> B polymorphicAdapt(C a) {
        String type = this.myKeyMap.getKey(a);
        if (type == null) {
            theLogger.warning("Unable to adapt, KeyMap returned null key.");
            return null;
        }
        Adapter<A, B> adapter = this.myAdapterMap.get(type);
        if (adapter != null) {
            Object b = null;
            try {
                b = adapter.adapt(a);
                if (b != null) {
                    return (B)b;
                }
            }
            catch (ClassCastException ex) {
                theLogger.log(Level.WARNING, "Found incompatible adapter for given class.  Class: " + a.getClass() + ", Adapter: " + adapter, ex);
                return null;
            }
            theLogger.info("Unable to adapt with specific adapter, returned null.");
        } else {
            theLogger.info("No specifc adapter, using default adapter.");
        }
        return null;
    }

    public static interface AdapterKeyMap<T> {
        public String getKey(T var1);
    }
}

