/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.lifecycle;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.robokind.api.common.property.PropertyChangeSource;

public interface ServiceLifecycleProvider<T>
extends PropertyChangeSource {
    public static final String PROP_DEPENDENCY_ADDED = "dependencyAdded";
    public static final String PROP_DEPENDENCY_REMOVED = "dependencyRemoved";

    public void start(Map<String, Object> var1);

    public void stop();

    public void dependencyChanged(String var1, Object var2, Map<String, Object> var3);

    public T getService();

    public List<DependencyDescriptor> getDependencyDescriptors();

    public Properties getRegistrationProperties();

    public String[] getServiceClassNames();

    public static class Validator {
        private static final Logger theLogger = Logger.getLogger(Validator.class.getName());

        public static boolean validateServices(List<DependencyDescriptor> descriptors, Map<String, Object> depdendencies) {
            if (descriptors == null || descriptors.isEmpty()) {
                return true;
            }
            if (depdendencies == null || depdendencies.isEmpty()) {
                for (DependencyDescriptor desc : descriptors) {
                    if (DependencyDescriptor.DependencyType.REQUIRED != desc.getDependencyType()) continue;
                    return false;
                }
                return true;
            }
            for (DependencyDescriptor descriptor : descriptors) {
                if (Validator.checkDescriptor(descriptor, depdendencies)) continue;
                return false;
            }
            return true;
        }

        private static boolean checkDescriptor(DependencyDescriptor descriptor, Map<String, Object> dependencies) {
            String id = descriptor.getDependencyName();
            Object req = dependencies.get(id);
            if (req == null) {
                return DependencyDescriptor.DependencyType.OPTIONAL == descriptor.getDependencyType();
            }
            Class reqClass = descriptor.getServiceClass();
            return reqClass.isAssignableFrom(req.getClass());
        }

        public static boolean validateService(List<DependencyDescriptor> descriptors, String dependencyId, Object dependency) {
            if (dependencyId == null || dependency == null) {
                theLogger.warning("Found null argument.  Returning false.");
                return false;
            }
            for (DependencyDescriptor descriptor : descriptors) {
                String id = descriptor.getDependencyName();
                Class reqClass = descriptor.getServiceClass();
                if (!dependencyId.equals(id) || !reqClass.isAssignableFrom(dependency.getClass())) continue;
                return true;
            }
            return false;
        }

        public static boolean validateServiceId(List<DependencyDescriptor> descriptors, String dependencyId) {
            if (dependencyId == null) {
                theLogger.warning("Found null dependencyId.  Returning false.");
                return false;
            }
            for (DependencyDescriptor descriptor : descriptors) {
                String id = descriptor.getDependencyName();
                if (!dependencyId.equals(id)) continue;
                return true;
            }
            return false;
        }
    }
}

