/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.playable;

import java.util.ArrayList;
import java.util.List;
import org.robokind.api.common.playable.PlayState;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.playable.PlayableListener;

public abstract class AbstractPlayable
implements Playable {
    protected PlayState myPlayState = PlayState.PENDING;
    protected Long myStartTime;
    protected Long myPauseTime;
    protected Long myResumeTime;
    protected Long myStopTime;
    protected List<PlayableListener> myPlayableListeners;
    protected Long myElapsedPauseTime = 0L;

    @Override
    public void addPlayableListener(PlayableListener listener) {
        if (this.myPlayableListeners == null) {
            this.myPlayableListeners = new ArrayList<PlayableListener>();
        }
        if (!this.myPlayableListeners.contains(listener)) {
            this.myPlayableListeners.add(listener);
        }
    }

    @Override
    public void removePlayableListener(PlayableListener listener) {
        if (this.myPlayableListeners == null) {
            return;
        }
        this.myPlayableListeners.remove(listener);
    }

    @Override
    public PlayState getPlayState() {
        return this.myPlayState;
    }

    protected abstract boolean onStart(long var1);

    protected abstract boolean onPause(long var1);

    protected abstract boolean onResume(long var1);

    protected abstract boolean onStop(long var1);

    protected abstract boolean onComplete(long var1);

    @Override
    public boolean start(long time) {
        if (this.myPlayState == PlayState.RUNNING) {
            return false;
        }
        if (!this.onStart(time)) {
            return false;
        }
        this.myStartTime = time;
        this.myElapsedPauseTime = 0L;
        this.changeState(PlayState.RUNNING, time);
        return true;
    }

    @Override
    public boolean pause(long time) {
        if (this.myPlayState != PlayState.RUNNING) {
            return false;
        }
        if (!this.onPause(time)) {
            return false;
        }
        this.myPauseTime = time;
        this.changeState(PlayState.PAUSED, time);
        return true;
    }

    @Override
    public boolean complete(long time) {
        if (this.myPlayState == PlayState.COMPLETED) {
            return true;
        }
        if (!this.onComplete(time)) {
            return false;
        }
        if (this.myPlayState == PlayState.PAUSED) {
            long elapsed = time - this.myPauseTime;
            this.myElapsedPauseTime = this.myElapsedPauseTime + elapsed;
        }
        this.myStopTime = time;
        this.changeState(PlayState.COMPLETED, time);
        this.afterComplete(time);
        return true;
    }

    protected void afterComplete(long time) {
    }

    @Override
    public boolean resume(long time) {
        if (this.myPlayState != PlayState.PAUSED) {
            return false;
        }
        if (!this.onResume(time)) {
            return false;
        }
        this.myResumeTime = time;
        long elapsed = time - this.myPauseTime;
        this.myElapsedPauseTime = this.myElapsedPauseTime + elapsed;
        this.changeState(PlayState.RUNNING, time);
        return true;
    }

    @Override
    public boolean stop(long time) {
        if (this.myPlayState == PlayState.STOPPED || this.myPlayState == PlayState.COMPLETED) {
            return false;
        }
        if (!this.onStop(time)) {
            return false;
        }
        this.changeState(PlayState.STOPPED, time);
        return true;
    }

    @Override
    public Long getStartTime() {
        return this.myStartTime;
    }

    @Override
    public Long getPauseTime() {
        return this.myPauseTime;
    }

    @Override
    public Long getResumeTime() {
        return this.myResumeTime;
    }

    @Override
    public Long getStopTime() {
        return this.myStopTime;
    }

    @Override
    public Long getElapsedPlayTime(long time) {
        if (this.myStartTime == null) {
            return 0L;
        }
        if (this.myPlayState == PlayState.RUNNING) {
            return time - (this.myStartTime + this.myElapsedPauseTime);
        }
        if (this.myPlayState == PlayState.PAUSED) {
            long ret = time - (this.myStartTime + this.myElapsedPauseTime);
            if (this.myPauseTime != null) {
                ret -= time - this.myPauseTime;
            }
            return ret;
        }
        if (this.myPlayState == PlayState.COMPLETED) {
            return this.myStopTime - (this.myStartTime + this.myElapsedPauseTime);
        }
        if (this.myPlayState == PlayState.STOPPED) {
            return this.myStopTime - (this.myStartTime + this.myElapsedPauseTime);
        }
        if (this.myPlayState == PlayState.PENDING) {
            return 0L;
        }
        return 0L;
    }

    @Override
    public Long getElapsedPauseTime(long time) {
        return this.myElapsedPauseTime;
    }

    private void changeState(PlayState state, long time) {
        PlayState prev = this.myPlayState;
        this.myStopTime = time;
        this.myPlayState = state;
        this.firePlayStateChanged(prev, this.myPlayState, this.myStopTime);
    }

    protected void firePlayStateChanged(PlayState prev, PlayState state, long time) {
        if (this.myPlayableListeners == null) {
            return;
        }
        for (PlayableListener listener : this.myPlayableListeners) {
            listener.playStateChanged(prev, state, time);
        }
    }
}

