/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.services;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ConfigurationLoader;
import org.robokind.api.common.services.ConfigurationWriter;
import org.robokind.api.common.services.ServiceContext;
import org.robokind.api.common.services.ServiceFactory;

public class ServiceConnectionDirectory {
    private static final Logger theLogger = Logger.getLogger(ServiceConnectionDirectory.class.getName());

    public static <ServiceClass, Param> ServiceClass buildService(BundleContext context, VersionProperty serviceVersion, VersionProperty configFormat, Param param, Class<Param> paramClass, Class<ServiceClass> serviceClass) throws Exception {
        if (context == null || serviceVersion == null || configFormat == null || param == null || paramClass == null || serviceClass == null) {
            throw new NullPointerException();
        }
        List<ServiceFactory<ServiceClass, ?>> factories = ServiceConnectionDirectory.getServiceFactories(context, serviceVersion, serviceClass);
        if (factories == null) {
            theLogger.log(Level.WARNING, "Unable to find ServiceFactories matching version: {0}, class: {1}.", new Object[]{serviceVersion.display(), serviceClass.getName()});
            return null;
        }
        for (ServiceFactory<ServiceClass, ?> factory : factories) {
            Class<?> configClass = factory.getConfigurationClass();
            List<ConfigurationLoader<?, Param>> loaders = ServiceConnectionDirectory.getConfigLoaders(context, configFormat, configClass, paramClass);
            if (loaders == null) {
                theLogger.log(Level.WARNING, "Unable to find ServiceLoader matching configFormat: {0}, config class: {1}, param class: {2}.", new Object[]{configFormat.display(), configClass.getName(), paramClass.getName()});
                continue;
            }
            for (ConfigurationLoader<?, Param> loader : loaders) {
                Object config = loader.loadConfiguration(param);
                if (config == null) {
                    theLogger.warning("Loader returned null configuration.  Trying next loader if available.");
                    continue;
                }
                ServiceClass serviceObj = factory.build(config);
                if (serviceObj == null) continue;
                return serviceObj;
            }
        }
        return null;
    }

    public static <ServiceClass, Param> ServiceContext<ServiceClass, ?, Param> buildServiceContext(BundleContext context, VersionProperty serviceVersion, VersionProperty configFormat, Class<ServiceClass> serviceClass, Class<Param> paramClass) {
        if (context == null) {
            return null;
        }
        List<ServiceFactory<ServiceClass, ?>> factories = ServiceConnectionDirectory.getServiceFactories(context, serviceVersion, serviceClass);
        if (factories == null) {
            return null;
        }
        for (ServiceFactory<ServiceClass, ?> factory : factories) {
            Class<?> configClass;
            List<ConfigurationLoader<?, Param>> loaders;
            if (factory == null || (loaders = ServiceConnectionDirectory.getConfigLoaders(context, configFormat, configClass = factory.getConfigurationClass(), paramClass)) == null) continue;
            for (ConfigurationLoader<?, Param> loader : loaders) {
                if (loader == null) continue;
                ServiceContext serviceContext = new ServiceContext(loader, factory);
                return serviceContext;
            }
        }
        return null;
    }

    public static <ServiceClass> List<ServiceFactory<ServiceClass, ?>> getServiceFactories(BundleContext context, VersionProperty serviceVersion, Class<ServiceClass> serviceClass) {
        if (context == null || serviceVersion == null || serviceClass == null) {
            return null;
        }
        try {
            ServiceReference[] refs = context.getServiceReferences(ServiceFactory.class.getName(), "(&(ServiceVersion=" + serviceVersion + ")(" + "serviceClass" + "=" + serviceClass.getName() + "))");
            if (refs == null || refs.length == 0) {
                theLogger.log(Level.WARNING, "Unable to find ServiceFactory with version={0} and class={1}", new Object[]{serviceVersion.toString(), serviceClass.getName()});
                return null;
            }
            ArrayList factories = new ArrayList(refs.length);
            for (ServiceReference ref : refs) {
                ServiceFactory factory = (ServiceFactory)context.getService(ref);
                if (factory == null) continue;
                factories.add(factory);
            }
            return factories;
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.SEVERE, "There was an error fetching service references.", ex);
            return null;
        }
    }

    public static <ServiceConfig, Param> List<ConfigurationLoader<ServiceConfig, Param>> getConfigLoaders(BundleContext context, VersionProperty configFormat, Class<ServiceConfig> configClass, Class<Param> paramClass) {
        if (configFormat == null || configClass == null || paramClass == null) {
            return null;
        }
        try {
            ServiceReference[] refs = context.getServiceReferences(ConfigurationLoader.class.getName(), "(&(configFormatVersion=" + configFormat + ")(" + "configClass" + "=" + configClass.getName() + ")(" + "configParamClass" + "=" + paramClass.getName() + "))");
            if (refs == null || refs.length == 0) {
                theLogger.log(Level.WARNING, "Unable to find ServiceConfigurationLoader with formatVersion={0}, configClass={1} and paramClass={2}", new Object[]{configFormat.toString(), configClass.getName(), paramClass.getName()});
                return null;
            }
            ArrayList<ConfigurationLoader<ServiceConfig, Param>> loaders = new ArrayList<ConfigurationLoader<ServiceConfig, Param>>(refs.length);
            for (ServiceReference ref : refs) {
                ConfigurationLoader loader = (ConfigurationLoader)context.getService(ref);
                if (loader == null) continue;
                loaders.add(loader);
            }
            return loaders;
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.SEVERE, "There was an error fetching service references.", ex);
            return null;
        }
    }

    public static <ServiceConfig, Param> List<ConfigurationWriter<ServiceConfig, Param>> getConfigWriters(BundleContext context, VersionProperty configFormat, Class<ServiceConfig> configClass, Class<Param> paramClass) {
        if (configFormat == null || configClass == null || paramClass == null) {
            return null;
        }
        try {
            ServiceReference[] refs = context.getServiceReferences(ConfigurationWriter.class.getName(), "(&(configFormatVersion=" + configFormat + ")(" + "configClass" + "=" + configClass.getName() + ")(" + "configParamClass" + "=" + paramClass.getName() + "))");
            if (refs == null || refs.length == 0) {
                theLogger.log(Level.WARNING, "Unable to find ServiceConfigurationWriter with formatVersion={0}, configClass={1} and paramClass={2}", new Object[]{configFormat.toString(), configClass.getName(), paramClass.getName()});
                return null;
            }
            ArrayList<ConfigurationWriter<ServiceConfig, Param>> writers = new ArrayList<ConfigurationWriter<ServiceConfig, Param>>(refs.length);
            for (ServiceReference ref : refs) {
                ConfigurationWriter loader = (ConfigurationWriter)context.getService(ref);
                if (loader == null) continue;
                writers.add(loader);
            }
            return writers;
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.SEVERE, "There was an error fetching service references.", ex);
            return null;
        }
    }
}

