/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.lifecycle;

public final class DependencyDescriptor {
    private String myDependencyName;
    private Class myDependencyClass;
    private String myDependencyFilter;
    private DependencyType myType;

    public DependencyDescriptor(String dependencyName, Class clazz, String filter) {
        this(dependencyName, clazz, filter, DependencyType.REQUIRED);
    }

    public DependencyDescriptor(String dependencyName, Class clazz, String filter, DependencyType type) {
        if (dependencyName == null || clazz == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            type = DependencyType.REQUIRED;
        }
        this.myDependencyName = dependencyName;
        this.myDependencyClass = clazz;
        this.myDependencyFilter = filter;
        this.myType = type;
    }

    public String getDependencyName() {
        return this.myDependencyName;
    }

    public Class getServiceClass() {
        return this.myDependencyClass;
    }

    public String getServiceFilter() {
        return this.myDependencyFilter;
    }

    public DependencyType getDependencyType() {
        return this.myType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyDescriptor other = (DependencyDescriptor)obj;
        if (this.myDependencyName == null ? other.myDependencyName != null : !this.myDependencyName.equals(other.myDependencyName)) {
            return false;
        }
        if (!(this.myDependencyClass == other.myDependencyClass || this.myDependencyClass != null && this.myDependencyClass.equals(other.myDependencyClass))) {
            return false;
        }
        if (this.myDependencyFilter == null ? other.myDependencyFilter != null : !this.myDependencyFilter.equals(other.myDependencyFilter)) {
            return false;
        }
        return this.myType == other.myType;
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + (this.myDependencyName != null ? this.myDependencyName.hashCode() : 0);
        hash = 19 * hash + (this.myDependencyClass != null ? this.myDependencyClass.hashCode() : 0);
        hash = 19 * hash + (this.myDependencyFilter != null ? this.myDependencyFilter.hashCode() : 0);
        hash = 19 * hash + (this.myType != null ? this.myType.hashCode() : 0);
        return hash;
    }

    public static enum DependencyType {
        REQUIRED,
        OPTIONAL;

    }
}

