/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.lifecycle.config;

import java.util.Properties;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.config.DefaultConfiguration;
import org.jflux.api.core.util.IndexedValue;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.robokind.api.common.lifecycle.config.GenericLifecycle;
import org.robokind.api.common.osgi.OSGiUtils;

public class RKDependencyConfigUtils {
    public static final String CONF_DEPENDENCY_NAME = "lifecycleDependencyLocalName";
    public static final String CONF_DEPENDENCY_CLASS = "lifecycleDependencyClass";
    public static final String CONF_DEPENDENCY_PROPERTIES = "lifecycleDependencyProperties";
    public static final String CONFIG_DEPENDENCY_DESCRIPTOR = "lifecycleDependencyDescriptorConfig";
    public static final String CONF_DEPENDENCY_CHANGE_LISTENER = "lifecycleDependencyChangeListener";

    private static DefaultConfiguration<String> buildBaseDescriptorConfig(String name, Class clazz, Properties props) {
        DefaultConfiguration conf = new DefaultConfiguration();
        if (name == null || clazz == null) {
            throw new NullPointerException();
        }
        conf.addProperty(String.class, (Object)CONF_DEPENDENCY_NAME, (Object)name);
        conf.addProperty(Class.class, (Object)CONF_DEPENDENCY_CLASS, (Object)clazz);
        conf.addProperty(Properties.class, (Object)CONF_DEPENDENCY_PROPERTIES, (Object)props);
        return conf;
    }

    public static Configuration<String> buildDescriptorConfig(String name, Class clazz, Properties props) {
        return RKDependencyConfigUtils.buildBaseDescriptorConfig(name, clazz, props);
    }

    public static <T, D> Configuration<String> buildLifecycleDependencyConfig(String name, Class<D> clazz, Properties props, Listener<GenericLifecycle.DependencyChange<T, D>> changeListener) {
        return RKDependencyConfigUtils.buildLifecycleDependencyConfig(RKDependencyConfigUtils.buildBaseDescriptorConfig(name, clazz, props), changeListener);
    }

    public static <T, D> Configuration<String> buildLifecycleDependencyConfig(String name, Class<D> clazz, String idKey, String idStr, Properties props, Listener<GenericLifecycle.DependencyChange<T, D>> changeListener) {
        return RKDependencyConfigUtils.buildLifecycleDependencyConfig(RKDependencyConfigUtils.buildBaseDescriptorConfig(name, clazz, RKDependencyConfigUtils.getProps(idKey, idStr, props)), changeListener);
    }

    private static Properties getProps(String idKey, String idStr, Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.put(idKey, idStr);
        return props;
    }

    public static <T, D> Configuration<String> buildLifecycleDependencyConfig(Configuration<String> descriptorConfig, Listener<GenericLifecycle.DependencyChange<T, D>> changeListener) {
        DefaultConfiguration conf = new DefaultConfiguration();
        if (descriptorConfig == null) {
            throw new NullPointerException();
        }
        conf.addProperty(Configuration.class, (Object)CONFIG_DEPENDENCY_DESCRIPTOR, descriptorConfig);
        conf.addProperty(Listener.class, (Object)CONF_DEPENDENCY_CHANGE_LISTENER, changeListener);
        return conf;
    }

    public static DependencyDescriptor buildDescriptor(Configuration<String> a) {
        if (a == null) {
            throw new NullPointerException();
        }
        String name = (String)a.getPropertyValue(String.class, (Object)CONF_DEPENDENCY_NAME);
        Class clazz = (Class)a.getPropertyValue(Class.class, (Object)CONF_DEPENDENCY_CLASS);
        Properties props = (Properties)a.getPropertyValue(Properties.class, (Object)CONF_DEPENDENCY_PROPERTIES);
        String filter = OSGiUtils.createServiceFilter(props);
        return new DependencyDescriptor(name, clazz, filter);
    }

    public static IndexedValue<DependencyDescriptor, Listener<GenericLifecycle.DependencyChange>> buildLifecycleDependency(Configuration<String> a) {
        if (a == null) {
            throw new NullPointerException();
        }
        Configuration conf = (Configuration)a.getPropertyValue(Configuration.class, (Object)CONFIG_DEPENDENCY_DESCRIPTOR);
        Listener changeListener = (Listener)a.getPropertyValue(Listener.class, (Object)CONF_DEPENDENCY_CHANGE_LISTENER);
        if (conf == null) {
            throw new NullPointerException();
        }
        DependencyDescriptor desc = RKDependencyConfigUtils.buildDescriptor((Configuration<String>)conf);
        if (desc == null) {
            throw new NullPointerException();
        }
        return new IndexedValue.BasicIndexedValue((Object)desc, (Object)changeListener);
    }

    public static class DependencyDescriptorBuilder
    implements Adapter<Configuration<String>, DependencyDescriptor> {
        public DependencyDescriptor adapt(Configuration<String> a) {
            return RKDependencyConfigUtils.buildDescriptor(a);
        }
    }
}

