/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.lifecycle.config;

import java.util.Properties;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.config.DefaultConfiguration;
import org.robokind.api.common.lifecycle.ManagedService;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.config.SelfBuildingConfig;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;

public class RKManagedServiceConfigUtils {
    public static final String CONF_SERVICE_PROPERTIES = "managedServiceRegistrationProperties";
    public static final String CONF_UNIQUE_SERVICE_PROPERTIES = "managedServiceUniqueRegistrationProperties";
    public static final String CONF_SELFBUILD_LIFCEYCLE_CONFIG = "managedServiceSelfBuildingLifecycleConfig";
    public static final String CONF_SERVICE_LIFCEYCLE = "managedServiceLifecycle";

    private static DefaultConfiguration<String> buildBaseConfig(Properties props, Properties uniqueProps) {
        DefaultConfiguration conf = new DefaultConfiguration();
        conf.addProperty(Properties.class, (Object)CONF_SERVICE_PROPERTIES, (Object)props);
        conf.addProperty(Properties.class, (Object)CONF_UNIQUE_SERVICE_PROPERTIES, (Object)uniqueProps);
        return conf;
    }

    public static Configuration<String> buildManagedServiceConfig(Properties props, Properties uniqueProps, Configuration<String> selfBuildLifecycleConf) {
        DefaultConfiguration<String> conf = RKManagedServiceConfigUtils.buildBaseConfig(props, uniqueProps);
        conf.addProperty(Configuration.class, (Object)CONF_SELFBUILD_LIFCEYCLE_CONFIG, selfBuildLifecycleConf);
        return conf;
    }

    public static Configuration<String> buildManagedServiceConfig(Properties props, Properties uniqueProps, ServiceLifecycleProvider lifecycle) {
        DefaultConfiguration<String> conf = RKManagedServiceConfigUtils.buildBaseConfig(props, uniqueProps);
        conf.addProperty(ServiceLifecycleProvider.class, (Object)CONF_SERVICE_LIFCEYCLE, (Object)lifecycle);
        return conf;
    }

    public static class GenericManagedServiceFactory<T>
    implements Adapter<Configuration<String>, ManagedService<T>> {
        ManagedServiceFactory myFactory;

        public GenericManagedServiceFactory(ManagedServiceFactory factory) {
            this.myFactory = factory;
        }

        public ManagedService<T> adapt(Configuration<String> a) {
            return GenericManagedServiceFactory.buildManagedService(this.myFactory, a);
        }

        private static <T> ManagedService<T> buildManagedService(ManagedServiceFactory factory, Configuration<String> config) {
            ServiceLifecycleProvider<T> lifecycle = GenericManagedServiceFactory.getLifecycle(config);
            if (lifecycle == null) {
                throw new NullPointerException();
            }
            Properties props = (Properties)config.getPropertyValue(Properties.class, (Object)RKManagedServiceConfigUtils.CONF_SERVICE_PROPERTIES);
            Properties uniqueProps = (Properties)config.getPropertyValue(Properties.class, (Object)RKManagedServiceConfigUtils.CONF_UNIQUE_SERVICE_PROPERTIES);
            return factory.createService(lifecycle, props, uniqueProps);
        }

        private static <T> ServiceLifecycleProvider<T> getLifecycle(Configuration<String> config) {
            ServiceLifecycleProvider lifecycle = (ServiceLifecycleProvider)config.getPropertyValue(ServiceLifecycleProvider.class, (Object)RKManagedServiceConfigUtils.CONF_SERVICE_LIFCEYCLE);
            if (lifecycle != null) {
                return lifecycle;
            }
            Configuration lifecycleConfig = (Configuration)config.getPropertyValue(Configuration.class, (Object)RKManagedServiceConfigUtils.CONF_SELFBUILD_LIFCEYCLE_CONFIG);
            if (lifecycleConfig == null) {
                throw new NullPointerException();
            }
            return (ServiceLifecycleProvider)SelfBuildingConfig.selfBuild((Configuration<String>)lifecycleConfig);
        }
    }
}

