/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.api.common.services;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class Constants {
    /**
     * Property String for the Service VersionProperty.
     */
    public final static String SERVICE_VERSION = "ServiceVersion";
    /**
     * Property String for the Class of the Service connected to.
     */
    public final static String SERVICE_CLASS = "serviceClass";
    /**
     * Property String for the Configuration Format VersionProperty
     */
    public final static String CONFIG_FORMAT_VERSION = "configFormatVersion";
    /**
     * Property String for the Class of the ServiceConfig being loaded.
     */
    public final static String CONFIG_CLASS = "configClass";
    /**
     * Property String for the Parameter Class used by the 
     * ServiceConfigurationLoader and ServiceConfigurationWriter.
     */
    public final static String CONFIG_PARAM_CLASS = "configParamClass";
    /**
     * Property String for the id of a config loader parameter object.
     */
    public final static String CONFIG_PARAM_ID = "configParamId";
    
}
