/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.property.PropertyChangeNotifier;

public abstract class AbstractLifecycleProvider<I, T extends I>
extends PropertyChangeNotifier
implements ServiceLifecycleProvider<I> {
    private static final Logger theLogger = Logger.getLogger(AbstractLifecycleProvider.class.getName());
    private List<DependencyDescriptor> myDescriptors;
    private List<DependencyDescriptor> myRuntimeDescriptors;
    private boolean myStaisfiedFlag;
    protected T myService;
    protected Properties myRegistrationProperties;
    protected String[] myServiceClassNames;

    public AbstractLifecycleProvider(List<DependencyDescriptor> deps) {
        if (deps == null) {
            throw new NullPointerException();
        }
        this.myStaisfiedFlag = false;
        this.myDescriptors = deps;
    }

    @Override
    public synchronized void start(Map<String, Object> dependencies) {
        if (!ServiceLifecycleProvider.Validator.validateServices(this.myDescriptors, dependencies)) {
            throw new IllegalArgumentException("Invalid Dependency set for factory.");
        }
        this.myService = this.create(dependencies);
        this.myStaisfiedFlag = true;
    }

    @Override
    public synchronized void stop() {
    }

    protected abstract T create(Map<String, Object> var1);

    @Override
    public synchronized T getService() {
        if (!this.isSatisfied()) {
            return null;
        }
        return this.myService;
    }

    @Override
    public Properties getRegistrationProperties() {
        return this.myRegistrationProperties;
    }

    @Override
    public List<DependencyDescriptor> getDependencyDescriptors() {
        return this.myDescriptors;
    }

    public boolean isSatisfied() {
        return this.myStaisfiedFlag;
    }

    @Override
    public synchronized void dependencyChanged(String dependencyName, Object dependency, Map<String, Object> dependencies) {
        if (dependencyName == null) {
            throw new NullPointerException();
        }
        if (!this.validate(dependencyName, dependency)) {
            return;
        }
        this.myStaisfiedFlag = ServiceLifecycleProvider.Validator.validateServices(this.myDescriptors, dependencies);
        if (this.myService == null && this.isSatisfied()) {
            this.myService = this.create(dependencies);
            return;
        }
        this.handleChange(dependencyName, dependency, dependencies);
    }

    protected abstract void handleChange(String var1, Object var2, Map<String, Object> var3);

    private boolean validate(String id, Object req) {
        List<DependencyDescriptor> reqs = this.getDependencyDescriptors();
        if (req != null) {
            if (ServiceLifecycleProvider.Validator.validateService(reqs, id, req)) {
                return true;
            }
            theLogger.log(Level.WARNING, "Invalid service or id.  id: {0}, service: {1}", new Object[]{id, req});
            return false;
        }
        if (ServiceLifecycleProvider.Validator.validateServiceId(reqs, id)) {
            return true;
        }
        theLogger.log(Level.WARNING, "Invalid service id: {0}.", id);
        return false;
    }

    protected abstract Class<I> getServiceClass();

    @Override
    public String[] getServiceClassNames() {
        if (this.myServiceClassNames == null) {
            this.myServiceClassNames = new String[]{this.getServiceClass().getName()};
        }
        return this.myServiceClassNames;
    }

    protected boolean addRuntimeDependency(DependencyDescriptor desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        for (DependencyDescriptor d : this.getDependencyDescriptors()) {
            if (!desc.getDependencyName().equals(d.getDependencyName())) continue;
            theLogger.log(Level.WARNING, "Unable to add depenedency, name already in use: {0}", desc.getDependencyName());
            return false;
        }
        if (this.myRuntimeDescriptors == null) {
            this.myRuntimeDescriptors = new ArrayList<DependencyDescriptor>();
        }
        theLogger.log(Level.INFO, "Adding optional runtime depenedency {0}", desc.getDependencyName());
        this.myDescriptors.add(desc);
        this.myRuntimeDescriptors.add(desc);
        this.firePropertyChange("dependencyAdded", null, desc);
        return true;
    }

    protected boolean removeRuntimeDependency(String depName) {
        if (depName == null) {
            throw new NullPointerException();
        }
        if (this.myRuntimeDescriptors == null) {
            return false;
        }
        DependencyDescriptor desc = this.getRuntimeDescriptor(depName);
        if (desc == null) {
            theLogger.log(Level.WARNING, "Could not find optional runtime depenedency {0}", depName);
            return false;
        }
        theLogger.log(Level.INFO, "Removing optional runtime depenedency {0}", depName);
        this.myRuntimeDescriptors.remove(desc);
        this.myDescriptors.remove(desc);
        this.firePropertyChange("dependencyRemoved", null, desc);
        return true;
    }

    private DependencyDescriptor getRuntimeDescriptor(String name) {
        for (DependencyDescriptor d : this.myRuntimeDescriptors) {
            if (!name.equals(d.getDependencyName())) continue;
            return d;
        }
        return null;
    }
}

