/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.lifecycle.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.config.DefaultConfiguration;
import org.jflux.api.core.util.IndexedValue;
import org.jflux.api.core.util.MapAdapter;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.config.GenericLifecycle;
import org.robokind.api.common.lifecycle.config.RKDependencyConfigUtils;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;

public class RKLifecycleConfigUtils {
    public static final String CONF_SERVICE_CLASSES = "lifecycleServiceClasses";
    public static final String CONF_SERVICE_PROPERTIES = "lifecycleRegistrationProperties";
    public static final String CONF_DEPENDENCY_CONFIGS = "genericLifecycleDependencyConfigs";
    public static final String CONF_SERVICE_FACTORY = "genericLifecycleServiceFactory";
    public static final String CONF_SERVICE_STOP_LISTENER = "genericLifecycleStopListener";
    public static final String CONF_SIMPLE_LIFECYCLE_SERVICE = "simpleLifecycleService";

    private static DefaultConfiguration<String> buildBaseConfig(String[] classNames, Properties props) {
        DefaultConfiguration conf = new DefaultConfiguration();
        if (classNames == null) {
            throw new NullPointerException();
        }
        conf.addProperty(String[].class, (Object)CONF_SERVICE_CLASSES, (Object)classNames);
        conf.addProperty(Properties.class, (Object)CONF_SERVICE_PROPERTIES, (Object)props);
        return conf;
    }

    public static <T> Configuration<String> buildSimpleLifecycleConfig(Class<T> clazz, String[] availableClassNames, Properties props, T service) {
        DefaultConfiguration<String> conf = RKLifecycleConfigUtils.buildBaseConfig(availableClassNames, props);
        return conf;
    }

    public static <T> Configuration<String> buildSimpleLifecycleConfig(Class<T> clazz, Properties props, T service) {
        DefaultConfiguration<String> conf = RKLifecycleConfigUtils.buildBaseConfig(new String[]{clazz.getName()}, props);
        return conf;
    }

    public static <T> Configuration<String> buildSimpleLifecycleConfig(Class<T> clazz, String idKey, String idStr, Properties props, T service) {
        DefaultConfiguration<String> conf = RKLifecycleConfigUtils.buildBaseConfig(new String[]{clazz.getName()}, RKLifecycleConfigUtils.getProps(idKey, idStr, props));
        return conf;
    }

    private static Properties getProps(String idKey, String idStr, Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.put(idKey, idStr);
        return props;
    }

    private static <T> Configuration<String> addGenericLifecycleProps(DefaultConfiguration<String> conf, Iterable<Configuration<String>> dependencyConfigs, Adapter<Map<String, Object>, T> serviceFactory, Listener<T> stopListener) {
        conf.addProperty(Iterable.class, (Object)CONF_DEPENDENCY_CONFIGS, dependencyConfigs);
        conf.addProperty(Adapter.class, (Object)CONF_SERVICE_FACTORY, serviceFactory);
        if (stopListener != null) {
            conf.addProperty(Listener.class, (Object)CONF_SERVICE_STOP_LISTENER, stopListener);
        }
        return conf;
    }

    public static Configuration<String> buildGenericLifecycleConfig(String[] classNames, Properties props, Iterable<Configuration<String>> dependencyConfigs, Adapter<Map<String, Object>, ?> serviceFactory) {
        DefaultConfiguration<String> conf = RKLifecycleConfigUtils.buildBaseConfig(classNames, props);
        return RKLifecycleConfigUtils.addGenericLifecycleProps(conf, dependencyConfigs, serviceFactory, null);
    }

    public static Configuration<String> buildGenericLifecycleConfig(String[] classNames, String idKey, String idStr, Properties props, Iterable<Configuration<String>> dependencyConfigs, Adapter<Map<String, Object>, ?> serviceFactory) {
        return RKLifecycleConfigUtils.addGenericLifecycleProps(RKLifecycleConfigUtils.buildBaseConfig(classNames, RKLifecycleConfigUtils.getProps(idKey, idStr, props)), dependencyConfigs, serviceFactory, null);
    }

    public static <T> Configuration<String> buildGenericLifecycleConfig(String[] classNames, String idKey, String idStr, Properties props, Iterable<Configuration<String>> dependencyConfigs, Adapter<Map<String, Object>, T> serviceFactory, Listener<T> stopListener) {
        return RKLifecycleConfigUtils.addGenericLifecycleProps(RKLifecycleConfigUtils.buildBaseConfig(classNames, RKLifecycleConfigUtils.getProps(idKey, idStr, props)), dependencyConfigs, serviceFactory, stopListener);
    }

    public static SimpleLifecycle buildSimpleLifecycle(Configuration<String> conf) {
        String[] availableClassNames = (String[])conf.getPropertyValue(String[].class, (Object)CONF_SERVICE_CLASSES);
        Properties props = (Properties)conf.getPropertyValue(Properties.class, (Object)CONF_SERVICE_PROPERTIES);
        Object service = conf.getPropertyValue((Object)CONF_SIMPLE_LIFECYCLE_SERVICE);
        if (availableClassNames == null || service == null) {
            throw new NullPointerException();
        }
        return new SimpleLifecycle<Object>(service, availableClassNames, props);
    }

    public static GenericLifecycle buildGenericLifecycle(Configuration<String> conf) {
        String[] availableClassNames = (String[])conf.getPropertyValue(String[].class, (Object)CONF_SERVICE_CLASSES);
        Properties props = (Properties)conf.getPropertyValue(Properties.class, (Object)CONF_SERVICE_PROPERTIES);
        Iterable dependencyConfigs = (Iterable)conf.getPropertyValue(Iterable.class, (Object)CONF_DEPENDENCY_CONFIGS);
        Adapter serviceFactory = (Adapter)conf.getPropertyValue(Adapter.class, (Object)CONF_SERVICE_FACTORY);
        Listener stopListener = (Listener)conf.getPropertyValue(Listener.class, (Object)CONF_SERVICE_STOP_LISTENER);
        if (availableClassNames == null || dependencyConfigs == null || serviceFactory == null) {
            throw new NullPointerException();
        }
        List<IndexedValue<DependencyDescriptor, Listener<GenericLifecycle.DependencyChange>>> indexedChangeListeners = RKLifecycleConfigUtils.buildLifecycleDependencies(dependencyConfigs);
        ArrayList<DependencyDescriptor> descs = new ArrayList<DependencyDescriptor>(indexedChangeListeners.size());
        HashMap<String, Listener> changeListenerMap = new HashMap<String, Listener>(indexedChangeListeners.size());
        for (IndexedValue<DependencyDescriptor, Listener<GenericLifecycle.DependencyChange>> v : indexedChangeListeners) {
            DependencyDescriptor d = (DependencyDescriptor)v.getIndex();
            Listener l = (Listener)v.getValue();
            descs.add(d);
            if (l == null) continue;
            changeListenerMap.put(d.getDependencyName(), l);
        }
        MapAdapter listenerFinder = new MapAdapter(changeListenerMap);
        return new GenericLifecycle(availableClassNames, descs, props, serviceFactory, (Adapter<String, Listener<GenericLifecycle.DependencyChange>>)listenerFinder, stopListener);
    }

    private static List<IndexedValue<DependencyDescriptor, Listener<GenericLifecycle.DependencyChange>>> buildLifecycleDependencies(Iterable<Configuration<String>> configs) {
        ArrayList<IndexedValue<DependencyDescriptor, Listener<GenericLifecycle.DependencyChange>>> changeListeners = new ArrayList<IndexedValue<DependencyDescriptor, Listener<GenericLifecycle.DependencyChange>>>();
        for (Configuration<String> conf : configs) {
            IndexedValue<DependencyDescriptor, Listener<GenericLifecycle.DependencyChange>> val = RKDependencyConfigUtils.buildLifecycleDependency(conf);
            changeListeners.add(val);
        }
        return changeListeners;
    }

    public static class GenericLifecycleFactory<T>
    implements Adapter<Configuration<String>, ServiceLifecycleProvider<T>> {
        public ServiceLifecycleProvider<T> adapt(Configuration<String> a) {
            return RKLifecycleConfigUtils.buildGenericLifecycle(a);
        }
    }

    public static class SimpleLifecycleFactory<T>
    implements Adapter<Configuration<String>, ServiceLifecycleProvider<T>> {
        public ServiceLifecycleProvider<T> adapt(Configuration<String> a) {
            return RKLifecycleConfigUtils.buildSimpleLifecycle(a);
        }
    }
}

