/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.lifecycle.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.robokind.api.common.lifecycle.ManagedService;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;

public class ManagedServiceGroup {
    public static final String PROP_GROUP_ID = "serviceGroupId";
    private ManagedServiceFactory myFactory;
    private List<ServiceLifecycleProvider> myLifecycles;
    private List<ManagedService> myServices;
    private String myGroupId;
    private boolean myStartFlag;
    protected Properties myServiceProperties;

    public ManagedServiceGroup(ManagedServiceFactory factory, List<ServiceLifecycleProvider> lifecycles, String groupId, Properties registrationProperties) {
        if (factory == null || lifecycles == null || groupId == null) {
            throw new NullPointerException();
        }
        this.myFactory = factory;
        this.myLifecycles = lifecycles;
        this.myServiceProperties = registrationProperties;
        this.myGroupId = groupId;
        this.myStartFlag = false;
        if (this.myServiceProperties == null) {
            this.myServiceProperties = new Properties();
        }
        this.myServiceProperties.put(PROP_GROUP_ID, this.myGroupId);
    }

    public synchronized void start() {
        if (this.myStartFlag) {
            return;
        }
        if (this.myServices == null) {
            this.myServices = new ArrayList<ManagedService>(this.myLifecycles.size());
        }
        for (ServiceLifecycleProvider lifecycle : this.myLifecycles) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)this.myServiceProperties);
            ManagedService service = this.myFactory.createService(lifecycle, props);
            if (service == null) continue;
            this.myServices.add(service);
            service.start();
        }
        this.myStartFlag = true;
    }

    public synchronized void stop() {
        if (!this.myStartFlag || this.myServices == null || this.myServices.isEmpty()) {
            return;
        }
        for (ManagedService service : this.myServices) {
            service.stop();
            service.unregister();
        }
        this.myStartFlag = false;
    }
}

