/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.lifecycle.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.common.osgi.OSGiUtils;

public class DescriptorBuilder
extends DescriptorListBuilder {
    private DescriptorListBuilder myListBuilder;
    private String myDependencyName;
    private Class myDependencyClass;
    private List<String> myFilters;
    private DependencyDescriptor.DependencyType myType;

    public DescriptorBuilder(String name, Class clazz) {
        this(new DescriptorListBuilder(), name, clazz, DependencyDescriptor.DependencyType.REQUIRED);
    }

    public DescriptorBuilder(DescriptorListBuilder listBuilder, String name, Class clazz, DependencyDescriptor.DependencyType type) {
        if (listBuilder == null || name == null || clazz == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            type = DependencyDescriptor.DependencyType.REQUIRED;
        }
        this.myListBuilder = listBuilder;
        this.myDependencyName = name;
        this.myDependencyClass = clazz;
        this.myType = type;
        this.myFilters = new ArrayList<String>();
    }

    public DependencyDescriptor getDescriptor() {
        String filter = this.buildFilter();
        return new DependencyDescriptor(this.myDependencyName, this.myDependencyClass, filter, this.myType);
    }

    public DescriptorBuilder with(String key, String value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        this.myFilters.add(OSGiUtils.createFilter(key, value));
        return this;
    }

    public DescriptorBuilder with(String filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        this.myFilters.add(filter);
        return this;
    }

    public DescriptorBuilder with(Properties props) {
        if (props == null) {
            throw new NullPointerException();
        }
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            this.myFilters.add(OSGiUtils.createFilter(e.getKey().toString(), e.getValue().toString()));
        }
        return this;
    }

    public DescriptorBuilder optional() {
        this.myType = DependencyDescriptor.DependencyType.OPTIONAL;
        return this;
    }

    public DescriptorBuilder required() {
        this.myType = DependencyDescriptor.DependencyType.REQUIRED;
        return this;
    }

    @Override
    public DescriptorBuilder dependency(String name, Class clazz) {
        return this.finish().dependency(name, clazz);
    }

    @Override
    public List<DependencyDescriptor> getDescriptors() {
        return this.finish().getDescriptors();
    }

    private String buildFilter() {
        if (this.myFilters.isEmpty()) {
            return null;
        }
        StringBuilder filterBuilder = new StringBuilder();
        if (this.myFilters.size() > 1) {
            filterBuilder.append("(&");
        }
        for (String f : this.myFilters) {
            if (!(f = f.trim()).startsWith("(")) {
                filterBuilder.append("(");
            }
            filterBuilder.append(f);
            if (f.charAt(f.length() - 1) == ')') continue;
            filterBuilder.append(")");
        }
        if (this.myFilters.size() > 1) {
            filterBuilder.append(")");
        }
        return filterBuilder.toString();
    }

    private DescriptorListBuilder finish() {
        this.myListBuilder.getDescriptors().add(this.getDescriptor());
        return this.myListBuilder;
    }
}

