/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.robokind.api.common.osgi.OSGiUtils;

public class ClassTracker<T> {
    private static final Logger theLogger = Logger.getLogger(ClassTracker.class.getName());
    private String myTrackedClassName;
    private BundleContext myContext;
    private String myFilter;
    private ServiceTrackerCustomizer myCustomizer;
    private ServiceTracker myTracker;

    public static <C> ClassTracker<C> build(Class<C> clazz, String filter) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        BundleContext context = OSGiUtils.getBundleContext(clazz);
        if (context == null) {
            theLogger.log(Level.WARNING, "Could not find BundleContext for {0}", clazz);
            return null;
        }
        ClassTracker tracker = new ClassTracker(context, clazz.getName(), filter);
        return tracker;
    }

    public static <C> ClassTracker<C> build(Class<C> clazz, Properties props) {
        String filter = OSGiUtils.createServiceFilter(props);
        return ClassTracker.build(clazz, filter);
    }

    public ClassTracker(String className) {
        this.setTrackedClassName(className);
    }

    public ClassTracker(BundleContext context, String className, String filter) throws IllegalArgumentException {
        this.construct(context, className, filter, null);
    }

    public ClassTracker(BundleContext context, String className, String filter, ServiceTrackerCustomizer customizer) throws IllegalArgumentException {
        this.construct(context, className, filter, customizer);
    }

    private void setTrackedClassName(String className) {
        if (className == null) {
            throw new NullPointerException();
        }
        this.myTrackedClassName = "(objectClass=" + className + ")";
    }

    private void construct(BundleContext context, String className, String filter, ServiceTrackerCustomizer customizer) throws IllegalArgumentException {
        this.myContext = context;
        this.setTrackedClassName(className);
        this.myFilter = filter;
        this.myCustomizer = customizer;
        if (this.init()) {
            return;
        }
        String filterMsg = filter == null || filter.isEmpty() ? "" : ", Filter: " + filter;
        String custMsg = customizer == null ? "" : ", Customizer: " + customizer;
        throw new IllegalArgumentException("Unable to initialize ServiceTracker from given arguments.  BundleContext: " + context + ", ClassName: " + className + filterMsg + custMsg + ".");
    }

    public void setContext(BundleContext context) {
        this.myContext = context;
    }

    public void setFilter(String filter) {
        this.myFilter = filter;
    }

    public String getFilter() {
        return this.myFilter;
    }

    public void setCustomizer(ServiceTrackerCustomizer cust) {
        this.myCustomizer = cust;
    }

    public boolean init() {
        if (this.myContext == null) {
            return false;
        }
        if (this.myTracker != null) {
            this.myTracker.close();
            this.myTracker = null;
        }
        boolean empty = this.myFilter == null || this.myFilter.isEmpty();
        String filterStr = empty ? this.myTrackedClassName : "(&" + this.myTrackedClassName + this.myFilter + ")";
        try {
            Filter filter = this.myContext.createFilter(filterStr);
            this.myTracker = new ServiceTracker(this.myContext, filter, this.myCustomizer);
            this.myTracker.open();
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Could not create ServiceTracker, invalid filter syntax", ex);
            return false;
        }
        return true;
    }

    public void close() {
        if (this.myTracker == null) {
            return;
        }
        this.myTracker.close();
    }

    public List<T> getServices() {
        int len;
        if (this.myContext == null || this.myTracker == null) {
            return null;
        }
        Object[] objs = this.myTracker.getServices();
        int n = len = objs == null ? 0 : objs.length;
        if (len == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> ret = new ArrayList<Object>(len);
        for (Object t : objs) {
            try {
                ret.add(t);
            }
            catch (ClassCastException ex) {
                theLogger.log(Level.WARNING, "Found service not assignable to " + this.myTrackedClassName, ex);
            }
        }
        return ret;
    }

    public T getTopService() {
        if (this.myContext == null || this.myTracker == null) {
            return null;
        }
        Object[] objs = this.myTracker.getServices();
        if (objs == null || objs.length == 0) {
            return null;
        }
        for (Object t : objs) {
            if (t == null) continue;
            try {
                return (T)t;
            }
            catch (ClassCastException ex) {
                String warning = "Found service not assignable to " + this.myTrackedClassName + ".  Found type: " + t.getClass().toString();
                theLogger.log(Level.WARNING, warning, ex);
            }
        }
        return null;
    }
}

