/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.services;

import java.util.Properties;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.lifecycle.ManagedService;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.SingleServiceListener;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.api.common.services.ConfigurationLoader;
import org.robokind.api.common.services.ConfigurationWriter;
import org.robokind.api.common.services.ServiceFactory;

public class ServiceUtils {
    private static final Logger theLogger = Logger.getLogger(ServiceUtils.class.getName());

    public static ManagedService registerFactory(BundleContext context, ServiceFactory fact) {
        return ServiceUtils.registerFactory(context, fact, null);
    }

    public static ManagedService registerFactory(BundleContext context, ServiceFactory fact, Properties props) {
        if (context == null || fact == null) {
            throw new NullPointerException();
        }
        if (props == null) {
            props = new Properties();
        }
        props.put("ServiceVersion", fact.getServiceVersion().toString());
        props.put("serviceClass", fact.getServiceClass().getName());
        props.put("configClass", fact.getConfigurationClass().getName());
        OSGiComponent<ServiceFactory> ms = new OSGiComponent<ServiceFactory>(context, new SimpleLifecycle<ServiceFactory>(fact, ServiceFactory.class), props);
        ms.start();
        return ms;
    }

    public static ManagedService registerConfigLoader(BundleContext context, ConfigurationLoader loader) {
        return ServiceUtils.registerConfigLoader(context, loader, null);
    }

    public static ManagedService registerConfigLoader(BundleContext context, ConfigurationLoader loader, Properties props) {
        if (context == null || loader == null) {
            throw new NullPointerException();
        }
        if (props == null) {
            props = new Properties();
        }
        props.put("configFormatVersion", loader.getConfigurationFormat().toString());
        props.put("configClass", loader.getConfigurationClass().getName());
        props.put("configParamClass", loader.getParameterClass().getName());
        OSGiComponent<ConfigurationLoader> ms = new OSGiComponent<ConfigurationLoader>(context, new SimpleLifecycle<ConfigurationLoader>(loader, ConfigurationLoader.class), props);
        ms.start();
        return ms;
    }

    public static ManagedService registerConfigWriter(BundleContext context, ConfigurationWriter writer) {
        return ServiceUtils.registerConfigWriter(context, writer, null);
    }

    public static ManagedService registerConfigWriter(BundleContext context, ConfigurationWriter writer, Properties props) {
        if (context == null || writer == null) {
            throw new NullPointerException();
        }
        if (props == null) {
            props = new Properties();
        }
        props.put("configFormatVersion", writer.getConfigurationFormat().toString());
        props.put("configClass", writer.getConfigurationClass().getName());
        props.put("configParamClass", writer.getParameterClass().getName());
        OSGiComponent<ConfigurationWriter> ms = new OSGiComponent<ConfigurationWriter>(context, new SimpleLifecycle<ConfigurationWriter>(writer, ConfigurationWriter.class), props);
        ms.start();
        return ms;
    }

    public static <Conf, Param> SingleServiceListener<ConfigurationWriter<Conf, Param>> createWriterServiceListener(BundleContext context, Class<Conf> configClass, Class<Param> paramClass, VersionProperty configFormat, String serviceFilter) {
        Properties props = new Properties();
        props.put("configFormatVersion", configFormat.toString());
        props.put("configClass", configClass.getName());
        props.put("configParamClass", paramClass.getName());
        String writerFilter = OSGiUtils.createServiceFilter(props);
        if (serviceFilter != null && !serviceFilter.isEmpty()) {
            writerFilter = "(&" + writerFilter + "(" + serviceFilter + "))";
        }
        return new SingleServiceListener<ConfigurationWriter<Conf, Param>>(ConfigurationWriter.class, context, serviceFilter);
    }
}

