/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.lifecycle.config;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.DependencyDescriptor;

public class GenericLifecycle<T>
extends AbstractLifecycleProvider<T, T> {
    private Adapter<Map<String, Object>, T> myFactory;
    private Adapter<String, Listener<DependencyChange>> myChangeListeners;
    private Listener<T> myStopListener;

    public GenericLifecycle(String[] serviceClassNames, List<DependencyDescriptor> deps, Properties props, Adapter<Map<String, Object>, T> serviceFactory, Adapter<String, Listener<DependencyChange>> changeListeners, Listener<T> stopListener) {
        super(deps);
        if (serviceClassNames == null || serviceFactory == null || changeListeners == null) {
            throw new NullPointerException();
        }
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = props;
        } else if (props != null) {
            this.myRegistrationProperties.putAll((Map<?, ?>)props);
        }
        this.myFactory = serviceFactory;
        this.myChangeListeners = changeListeners;
        this.myServiceClassNames = serviceClassNames;
        this.myStopListener = stopListener;
    }

    @Override
    protected T create(Map<String, Object> dependencies) {
        return (T)this.myFactory.adapt(dependencies);
    }

    @Override
    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (this.myChangeListeners == null) {
            return;
        }
        Listener listener = (Listener)this.myChangeListeners.adapt((Object)name);
        if (listener == null) {
            return;
        }
        DependencyChange change = new DependencyChange(this, dependency, availableDependencies);
        listener.handleEvent(change);
    }

    @Override
    public void stop() {
        if (this.myStopListener != null && this.myService != null) {
            this.myStopListener.handleEvent(this.myService);
        }
        this.myService = null;
    }

    @Override
    public Class<T> getServiceClass() {
        return null;
    }

    public static class DependencyChange<T, D> {
        private GenericLifecycle<T> myLifecycle;
        private D myDependency;
        private Map<String, Object> myAvailableDependencies;

        protected DependencyChange(GenericLifecycle<T> lifecycle, D dependency, Map<String, Object> availableDependencies) {
            this.myDependency = dependency;
            this.myAvailableDependencies = availableDependencies;
            this.myLifecycle = lifecycle;
        }

        public Map<String, Object> getAvailableDependencies() {
            return this.myAvailableDependencies;
        }

        public D getDependency() {
            return this.myDependency;
        }

        public GenericLifecycle<T> getLifecycle() {
            return this.myLifecycle;
        }

        public T getService() {
            if (this.myLifecycle == null) {
                return null;
            }
            return (T)((GenericLifecycle)this.myLifecycle).myService;
        }
    }
}

