/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.position;

import org.robokind.api.common.utils.HashCodeUtil;

public class NormalizedDouble
implements Comparable,
Cloneable {
    private double myValue;

    public NormalizedDouble(double value) {
        this.rangeCheck(value);
        this.myValue = value;
    }

    public double getValue() {
        return this.myValue;
    }

    protected final void rangeCheck(double value) {
        if (!NormalizedDouble.isValid(value)) {
            throw new IllegalArgumentException("NormalizedRange must be within the range [0.0, 1.0] (0.0 <= val <= 1.0).");
        }
    }

    public static boolean isValid(double value) {
        return value >= 0.0 && value <= 1.0;
    }

    public int compareTo(Object o) {
        if (o == null || !NormalizedDouble.class.isAssignableFrom(o.getClass())) {
            return 1;
        }
        int compare = Double.compare(this.myValue, ((NormalizedDouble)o).myValue);
        if (compare == 0 && o.getClass() != this.getClass()) {
            return 1;
        }
        return compare;
    }

    public Object clone() {
        return new NormalizedDouble(this.myValue);
    }

    public String toString() {
        return Double.toString(this.myValue);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.myValue == ((NormalizedDouble)obj).myValue;
    }

    public int hashCode() {
        return HashCodeUtil.hash(23, this.myValue);
    }
}

