/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.utils;

import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeUtils {
    private static final Logger theLogger = Logger.getLogger(TimeUtils.class.getName());

    public static long now() {
        return System.currentTimeMillis();
    }

    public static void sleep(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException ex) {
            theLogger.log(Level.WARNING, "Thread sleep interrupted.", ex);
        }
    }

    public static String timeString(long millisec) {
        return TimeUtils.timeString(millisec, 0);
    }

    public static String timeString(long millisec, int len) {
        boolean neg;
        boolean bl = neg = millisec < 0L;
        if (neg) {
            millisec *= -1L;
        }
        String ret = "";
        int i = 0;
        while (i < 3) {
            long val = millisec % 10L;
            ret = val + ret;
            millisec /= 10L;
            ++i;
            --len;
        }
        do {
            long val = millisec % 60L;
            ret = val + ":" + ret;
            if (val < 10L) {
                ret = "0" + ret;
            }
            len -= 2;
        } while ((millisec /= 60L) > 0L);
        while (len > 0) {
            ret = "00:" + ret;
            len -= 2;
        }
        if (neg) {
            ret = "-" + ret;
        }
        return ret;
    }
}

