/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.lifecycle.config;

import java.util.List;
import java.util.Properties;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.config.Configuration;
import org.jflux.api.core.config.DefaultConfiguration;
import org.jflux.api.core.util.BatchAdapter;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.config.RKLifecycleConfigUtils;
import org.robokind.api.common.lifecycle.config.SelfBuildingConfig;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.common.lifecycle.utils.ManagedServiceGroup;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;

public class RKManagedGroupConfigUtils {
    public static final String CONFIG_GROUP_ID = "managedServiceGroupGroupId";
    public static final String CONFIG_GROUP_PROPERTIES = "managedServiceGroupRegistrationProperties";
    public static final String CONF_SELFBUILD_LIFCEYCLES = "managedServiceGroupSelfBuildingLifecycles";
    public static final String CONF_GENERIC_SELF_BUILDER = "managedServiceGroupGenericSelfBuildingBuilder";
    public static final String CONF_MANAGED_SERVICE_FACTORY = "managedServiceGroupManagedServiceFactory";

    private static DefaultConfiguration<String> buildBaseConfig(String groupId, Properties props, List<Configuration<String>> selfBuildLifecycles, Adapter<Configuration<String>, ServiceLifecycleProvider> genericSelfBuilder) {
        DefaultConfiguration conf = new DefaultConfiguration();
        if (groupId == null) {
            throw new NullPointerException();
        }
        if (selfBuildLifecycles == null || selfBuildLifecycles.isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one lifecycle");
        }
        conf.addProperty(String.class, (Object)CONFIG_GROUP_ID, (Object)groupId);
        conf.addProperty(Properties.class, (Object)CONFIG_GROUP_PROPERTIES, (Object)props);
        conf.addProperty(List.class, (Object)CONF_SELFBUILD_LIFCEYCLES, selfBuildLifecycles);
        conf.addProperty(Adapter.class, (Object)CONF_GENERIC_SELF_BUILDER, genericSelfBuilder);
        return conf;
    }

    public static Configuration<String> buildManagedGroupConfig(String groupId, Properties props, List<Configuration<String>> selfBuildLifecycles, Adapter<Configuration<String>, ServiceLifecycleProvider> genericSelfBuilder) {
        if (genericSelfBuilder == null) {
            throw new NullPointerException();
        }
        return RKManagedGroupConfigUtils.buildBaseConfig(groupId, props, selfBuildLifecycles, genericSelfBuilder);
    }

    public static Configuration<String> buildManagedGroupConfig(String groupId, Properties props, List<Configuration<String>> selfBuildLifecycles) {
        return RKManagedGroupConfigUtils.buildManagedGroupConfig(groupId, props, selfBuildLifecycles, new SelfBuildingConfig.DefaultSelfBuildingBuilder<ServiceLifecycleProvider>());
    }

    public static Configuration<String> makeSelfBuildingLifecycle(Configuration<String> lifecycleConfig) {
        return SelfBuildingConfig.buildSelfBuildingConfig(lifecycleConfig, new RKLifecycleConfigUtils.GenericLifecycleFactory());
    }

    public static <T> Configuration<String> makeSelfBuildingLifecycle(ServiceLifecycleProvider<T> lifecycle) {
        return SelfBuildingConfig.buildEmptySelfBuildingConfig(lifecycle);
    }

    public static <T> Configuration<String> makeSimpleSelfBuildingLifecycle(String[] classNames, T service, String idKey, String idStr, Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.put(idKey, idStr);
        return SelfBuildingConfig.buildEmptySelfBuildingConfig(new SimpleLifecycle<T>(service, classNames, props));
    }

    public static <T> Configuration<String> makeSimpleSelfBuildingLifecycle(String[] classNames, T service, Properties props) {
        return SelfBuildingConfig.buildEmptySelfBuildingConfig(new SimpleLifecycle<T>(service, classNames, props));
    }

    public static ManagedServiceGroup buildGroup(ManagedServiceFactory factory, Configuration<String> conf) {
        String groupId = (String)conf.getPropertyValue(String.class, (Object)CONFIG_GROUP_ID);
        Properties props = (Properties)conf.getPropertyValue(Properties.class, (Object)CONFIG_GROUP_PROPERTIES);
        List lifecycleConfigs = (List)conf.getPropertyValue(List.class, (Object)CONF_SELFBUILD_LIFCEYCLES);
        Adapter selfBuilder = (Adapter)conf.getPropertyValue(Adapter.class, (Object)CONF_GENERIC_SELF_BUILDER);
        List lifecycles = new BatchAdapter(selfBuilder).adapt((Iterable)lifecycleConfigs);
        return new ManagedServiceGroup(factory, lifecycles, groupId, props);
    }

    public static class ManagedGroupFactory
    implements Adapter<Configuration<String>, ManagedServiceGroup> {
        private ManagedServiceFactory myFactory;
        private boolean myStartFlag;

        public ManagedGroupFactory(ManagedServiceFactory fact, boolean startGroups) {
            if (fact == null) {
                throw new NullPointerException();
            }
            this.myFactory = fact;
            this.myStartFlag = startGroups;
        }

        public ManagedGroupFactory(ManagedServiceFactory fact) {
            this(fact, true);
        }

        public ManagedServiceGroup adapt(Configuration<String> a) {
            ManagedServiceGroup g = RKManagedGroupConfigUtils.buildGroup(this.myFactory, a);
            if (this.myStartFlag) {
                g.start();
            }
            return g;
        }
    }
}

