/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.osgi.lifecycle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.robokind.api.common.lifecycle.ManagedService;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.lifecycle.ServiceDependenciesTracker;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiComponent<T>
extends PropertyChangeNotifier
implements ManagedService<T> {
    private static final Logger theLogger = LoggerFactory.getLogger(OSGiComponent.class);
    private BundleContext myContext;
    private ServiceLifecycleProvider<T> myLifecycleProvider;
    private LifecycleDependencyListener myLifecycleListener;
    private ServiceDependenciesTracker myDependenciesTracker;
    private T myService;
    private ServiceRegistration myServiceRegistration;
    private ServiceRegistration mySelfRegistration;
    private Properties myRegistrationProperties;
    private Properties myUniqueProperties;
    private String[] myRegistrationClassNames;
    private boolean myInitializedFlag;
    private boolean myRegistrationEnabledFlag;
    private boolean mySelfRegistrationEnabledFlag;
    private static ThreadPoolExecutor theExecutor;
    private static int theCurrentThreadId;

    private static synchronized ThreadPoolExecutor getExecutor() {
        if (theExecutor == null) {
            theExecutor = new ScheduledThreadPoolExecutor(8);
            theExecutor.setThreadFactory(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "Service Manager Thread - " + theCurrentThreadId++);
                }
            });
            theExecutor.setKeepAliveTime(20L, TimeUnit.SECONDS);
            theExecutor.allowCoreThreadTimeOut(true);
        }
        return theExecutor;
    }

    private static void spawnThread(Runnable runnable) {
        ThreadPoolExecutor exec = OSGiComponent.getExecutor();
        exec.execute(runnable);
    }

    public OSGiComponent(BundleContext context, ServiceLifecycleProvider<T> lifecycle) {
        this(context, lifecycle, null, null, true);
    }

    public OSGiComponent(BundleContext context, ServiceLifecycleProvider<T> lifecycle, Properties registrationProps) {
        this(context, lifecycle, registrationProps, null, true);
    }

    public OSGiComponent(BundleContext context, ServiceLifecycleProvider<T> lifecycle, Properties registrationProps, boolean selfRegister) {
        this(context, lifecycle, registrationProps, null, selfRegister);
    }

    public OSGiComponent(BundleContext context, ServiceLifecycleProvider<T> lifecycle, Properties registrationProps, Properties uniqueProps, boolean selfRegister) {
        if (context == null || lifecycle == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myLifecycleProvider = lifecycle;
        List<DependencyDescriptor> descriptors = this.myLifecycleProvider.getDependencyDescriptors();
        this.myRegistrationClassNames = this.myLifecycleProvider.getServiceClassNames();
        this.myRegistrationProperties = registrationProps;
        this.myUniqueProperties = uniqueProps;
        this.myInitializedFlag = false;
        this.myRegistrationEnabledFlag = true;
        this.mySelfRegistrationEnabledFlag = selfRegister;
        if (descriptors == null || descriptors.isEmpty()) {
            return;
        }
        this.myDependenciesTracker = new ServiceDependenciesTracker(this.myContext);
        for (DependencyDescriptor dd : descriptors) {
            this.myDependenciesTracker.addDependencyDescription(dd.getServiceClass(), dd.getDependencyName(), dd.getServiceFilter(), dd.getDependencyType());
        }
        this.myDependenciesTracker.addPropertyChangeListener(new DependencyStatusListener());
    }

    @Override
    public void start() {
        OSGiComponent.spawnThread(new Runnable(){

            @Override
            public void run() {
                if (OSGiComponent.this.mySelfRegistrationEnabledFlag) {
                    OSGiComponent.this.registerSelf();
                }
                if (OSGiComponent.this.myLifecycleListener == null && OSGiComponent.this.myLifecycleProvider != null) {
                    OSGiComponent.this.myLifecycleListener = new LifecycleDependencyListener();
                    OSGiComponent.this.myLifecycleProvider.addPropertyChangeListener(OSGiComponent.this.myLifecycleListener);
                }
                OSGiComponent.this.__start();
            }
        });
    }

    public void __start() {
        if (this.myDependenciesTracker == null) {
            this.handleAllDependencies(Collections.EMPTY_MAP);
            return;
        }
        if (!this.myDependenciesTracker.isRunning()) {
            this.myDependenciesTracker.start();
        }
    }

    @Override
    public void stop() {
        if (this.myDependenciesTracker != null && this.myDependenciesTracker.isRunning()) {
            this.myDependenciesTracker.stop();
        }
        this.stopLifecycle();
    }

    private void stopLifecycle() {
        if (this.myLifecycleProvider == null) {
            return;
        }
        this.myLifecycleProvider.stop();
        if (this.myLifecycleListener != null) {
            this.myLifecycleProvider.removePropertyChangeListener(this.myLifecycleListener);
            this.myLifecycleListener = null;
        }
    }

    @Override
    public void dispose() {
        this.getLogger().info("Disposing of OSGi Component with class {}", this.getClass());
        this.getLogger().debug("Component Detail {}", this.myService);
        this.stopLifecycle();
        this.clearAllListeners();
        if (this.myDependenciesTracker != null) {
            this.myDependenciesTracker.dispose();
            this.myDependenciesTracker = null;
        }
        this.unregister();
        this.unregisterSelf();
        this.myContext = null;
        if (this.myRegistrationProperties != null) {
            this.myRegistrationProperties.clear();
        }
        if (this.myUniqueProperties != null) {
            this.myUniqueProperties.clear();
        }
        this.myRegistrationClassNames = null;
        this.myLifecycleProvider = null;
        this.myService = null;
    }

    public void setSelfRegistrationEnabled(boolean enabled) {
        this.mySelfRegistrationEnabledFlag = enabled;
        if (this.mySelfRegistrationEnabledFlag && this.mySelfRegistration == null) {
            this.registerSelf();
        } else if (!this.mySelfRegistrationEnabledFlag && this.myServiceRegistration != null) {
            this.unregisterSelf();
        }
    }

    public boolean getSelfRegistrationEnabled() {
        return this.mySelfRegistrationEnabledFlag;
    }

    public void registerSelf() {
        if (this.mySelfRegistration != null) {
            return;
        }
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put("serviceType", this.getServiceClassNames());
        this.mySelfRegistration = this.myContext.registerService(ManagedService.class.getName(), (Object)this, props);
    }

    public void unregisterSelf() {
        if (this.mySelfRegistration == null) {
            return;
        }
        this.mySelfRegistration.unregister();
        this.mySelfRegistration = null;
    }

    @Override
    public void setRegistrationEnabled(boolean enabled) {
        this.myRegistrationEnabledFlag = enabled;
        if (this.myRegistrationEnabledFlag && this.myService != null && this.myServiceRegistration == null) {
            this.register();
        } else if (!this.myRegistrationEnabledFlag && this.myServiceRegistration != null) {
            this.unregister();
        }
    }

    @Override
    public boolean getRegistrationEnabled() {
        return this.myRegistrationEnabledFlag;
    }

    @Override
    public void unregister() {
        OSGiComponent.spawnThread(new Runnable(){

            @Override
            public void run() {
                OSGiComponent.this.__unregister();
            }
        });
    }

    public void __unregister() {
        if (this.myServiceRegistration != null) {
            try {
                this.myServiceRegistration.unregister();
                this.myServiceRegistration = null;
                if (this.myService != null) {
                    this.getLogger().info("Service Successfully Unregistered, class= {}", this.myService.getClass());
                    this.getLogger().debug("Service Details: {}", this.myService);
                } else {
                    this.getLogger().warn("Component for null service unregistered.");
                }
            }
            catch (IllegalStateException ex) {
                this.getLogger().warn("Caught illegalStateException during service unregistration for {}", this.myService);
            }
        }
        Object changeKey = new Object();
        try {
            this.firePropertyChange("serviceChanged", changeKey, this);
        }
        catch (RuntimeException ex) {
            this.getLogger().warn("Runtime exception in event handling for unregistration of svc {} ", this.myService, (Object)ex);
        }
    }

    @Override
    public void register() {
        this.__register();
    }

    public void __register() {
        ServiceRegistration reg;
        if (this.myService == null || this.myServiceRegistration != null || !this.myRegistrationEnabledFlag) {
            return;
        }
        Properties props = this.getRegistrationProperties();
        if (!this.uniquePropertiesAvailable()) {
            this.getLogger().warn("Unable to register service.  One or more unique property is in use.");
            return;
        }
        Hashtable<String, Object> propTable = new Hashtable<String, Object>();
        if (props != null) {
            for (Object prop : props.keySet()) {
                ((Dictionary)propTable).put(prop.toString(), props.get(prop));
            }
        }
        this.myServiceRegistration = reg = this.myContext.registerService(this.myRegistrationClassNames, this.myService, propTable);
        this.getLogger().info("Service successfully registered,  class={}", this.myService.getClass());
        this.getLogger().debug("Service details: {}", this.myService);
        Object changeKey = new Object();
        try {
            this.firePropertyChange("serviceChanged", changeKey, this);
        }
        catch (RuntimeException ex) {
            this.getLogger().warn("Runtime exception in event handling for registration of svc {}" + this.myService, (Throwable)ex);
        }
    }

    private boolean uniquePropertiesAvailable() {
        if (this.myUniqueProperties == null) {
            return true;
        }
        for (Map.Entry<Object, Object> e : this.myUniqueProperties.entrySet()) {
            String val;
            String key = e.getKey().toString();
            String filter = OSGiUtils.createFilter(key, val = e.getValue().toString());
            if (!OSGiUtils.serviceExists(this.myContext, this.myRegistrationClassNames, filter).booleanValue()) continue;
            this.getLogger().warn("Unique service property already in use: ({}={}).", (Object)key, (Object)val);
            return false;
        }
        return true;
    }

    private void handleAllDependencies(Map<String, Object> requiredServices) {
        if (!ServiceLifecycleProvider.Validator.validateServices(this.myLifecycleProvider.getDependencyDescriptors(), requiredServices)) {
            throw new IllegalArgumentException("Invalid dependency set for service.");
        }
        this.myLifecycleProvider.start(requiredServices);
        this.myService = this.myLifecycleProvider.getService();
        if (this.myService == null) {
            this.getLogger().warn("The lifecycle failed to create a service.");
        } else {
            this.getLogger().info("Service created of type(s): {}", (Object)Arrays.toString(this.myLifecycleProvider.getServiceClassNames()));
            this.register();
        }
        this.myLifecycleListener.flush();
    }

    private void handleChanged(String id, Object newDependency) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (!this.validate(id, newDependency)) {
            throw new IllegalArgumentException("Invalid id or dependency.  id: " + id + ", dependency: " + newDependency);
        }
        this.myLifecycleProvider.dependencyChanged(id, newDependency, this.myDependenciesTracker.getAvailableDependencies());
        this.checkForModification();
        this.myLifecycleListener.flush();
    }

    private boolean validate(String id, Object req) {
        List<DependencyDescriptor> reqs = this.myLifecycleProvider.getDependencyDescriptors();
        return req == null && ServiceLifecycleProvider.Validator.validateServiceId(reqs, id) || ServiceLifecycleProvider.Validator.validateService(reqs, id, req);
    }

    private void checkForModification() {
        T service = this.myLifecycleProvider.getService();
        if (this.myService == null && service == null) {
            return;
        }
        if (service == null && this.myService != null) {
            this.getLogger().info("Required Service change stopped this service.  Service is being unregistered.");
            this.unregister();
            this.myService = null;
        } else if (service != null && this.myService == null) {
            this.getLogger().info("Required Service change has started this service.");
            if (this.myServiceRegistration != null) {
                this.unregister();
            }
            this.myService = service;
            this.register();
        } else if (service != this.myService) {
            this.getLogger().info("Required Service change has changed this service.");
            ServiceRegistration oldReg = this.myServiceRegistration;
            this.myService = service;
            this.register();
            if (oldReg != null) {
                oldReg.unregister();
            }
        }
    }

    @Override
    public List<DependencyDescriptor> getDependencies() {
        if (this.myLifecycleProvider == null) {
            return null;
        }
        return this.myLifecycleProvider.getDependencyDescriptors();
    }

    @Override
    public boolean getDependencyStatus(String dependencyId) {
        if (this.myDependenciesTracker == null) {
            return false;
        }
        return this.myDependenciesTracker.getDependency(dependencyId) != null;
    }

    @Override
    public Properties getRegistrationProperties() {
        Properties props = this.myLifecycleProvider.getRegistrationProperties();
        Properties allProps = new Properties();
        if (props != null) {
            allProps.putAll((Map<?, ?>)props);
        }
        if (this.myRegistrationProperties != null) {
            allProps.putAll((Map<?, ?>)this.myRegistrationProperties);
        }
        if (this.myUniqueProperties != null) {
            allProps.putAll((Map<?, ?>)this.myUniqueProperties);
        }
        return allProps;
    }

    @Override
    public boolean isAvailable() {
        return this.myService != null;
    }

    @Override
    public boolean isRegistered() {
        return this.isAvailable() && this.myServiceRegistration != null;
    }

    @Override
    public String[] getServiceClassNames() {
        return this.myLifecycleProvider.getServiceClassNames();
    }

    @Override
    public int getDependencyCount() {
        List<DependencyDescriptor> deps = this.getDependencies();
        if (deps == null) {
            return 0;
        }
        return deps.size();
    }

    @Override
    public int getAvailableDependencyCount() {
        if (this.myDependenciesTracker == null) {
            return 0;
        }
        Map<String, Object> map = this.myDependenciesTracker.getAvailableDependencies();
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public Logger getLogger() {
        return theLogger;
    }

    static {
        theCurrentThreadId = 0;
    }

    class LifecycleDependencyListener
    implements PropertyChangeListener {
        private Queue<DependencyDescriptor> myAddQueue = new LinkedList<DependencyDescriptor>();

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt == null) {
                return;
            }
            String eventName = evt.getPropertyName();
            Object obj = evt.getNewValue();
            if (obj == null || !(obj instanceof DependencyDescriptor)) {
                return;
            }
            DependencyDescriptor desc = (DependencyDescriptor)obj;
            if ("dependencyAdded".equals(eventName)) {
                this.addDesc(desc);
            } else if ("dependencyRemoved".equals(eventName)) {
                this.remove(eventName);
            }
        }

        private synchronized void addDesc(DependencyDescriptor desc) {
            for (DependencyDescriptor d : this.myAddQueue) {
                if (!desc.getDependencyName().equals(d.getDependencyName())) continue;
                return;
            }
            this.myAddQueue.add(desc);
        }

        private synchronized void remove(String name) {
            if (OSGiComponent.this.myDependenciesTracker.removeDependencyTracker(name)) {
                return;
            }
            DependencyDescriptor remove = null;
            for (DependencyDescriptor desc : this.myAddQueue) {
                if (!name.equals(desc.getDependencyName())) continue;
                remove = desc;
                break;
            }
            if (remove != null) {
                this.myAddQueue.remove(remove);
            }
        }

        private synchronized void flush() {
            while (!this.myAddQueue.isEmpty()) {
                DependencyDescriptor desc = this.myAddQueue.poll();
                if (desc == null) continue;
                OSGiComponent.this.myDependenciesTracker.addDependencyDescription(desc);
            }
        }
    }

    class DependencyStatusListener
    implements PropertyChangeListener {
        DependencyStatusListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt == null) {
                return;
            }
            String name = evt.getPropertyName();
            if ("allDependenciesAvailable".equals(name)) {
                this.handleAllAvailable(evt);
            } else if ("dependencyChanged".equals(name)) {
                this.dependencyChange(evt);
            } else if ("dependencyAvailable".equals(name)) {
                this.dependencyChange(evt);
            } else if ("dependencyUnavailable".equals(name)) {
                this.dependencyChange(evt);
            }
        }

        private void dependencyChange(PropertyChangeEvent evt) {
            String id = evt.getOldValue().toString();
            if (OSGiComponent.this.myInitializedFlag) {
                Object obj = evt.getNewValue();
                OSGiComponent.this.handleChanged(id, obj);
            }
            OSGiComponent.this.firePropertyChange("dependencyChanged", null, id);
        }

        private void handleAllAvailable(PropertyChangeEvent evt) {
            if (OSGiComponent.this.myInitializedFlag) {
                return;
            }
            OSGiComponent.this.myInitializedFlag = true;
            OSGiComponent.this.getLogger().info("All requirements available, attempting to create service.");
            Object obj = evt.getNewValue();
            if (obj == null || !(obj instanceof Map)) {
                OSGiComponent.this.getLogger().warn("Invalid requirement map, cannot create service.");
                OSGiComponent.this.myInitializedFlag = false;
                return;
            }
            try {
                Map reqs = (Map)obj;
                OSGiComponent.this.handleAllDependencies(reqs);
            }
            catch (ClassCastException ex) {
                OSGiComponent.this.getLogger().warn("Improper requirement Map type.", (Throwable)ex);
                OSGiComponent.this.myInitializedFlag = false;
                return;
            }
        }
    }
}

