/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.osgi.lifecycle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.DependencyDescriptor;
import org.robokind.api.common.osgi.SingleServiceListener;
import org.robokind.api.common.property.PropertyChangeNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDependenciesTracker
extends PropertyChangeNotifier {
    private static final Logger theLogger = LoggerFactory.getLogger(ServiceDependenciesTracker.class);
    public static final String PROP_DEPENDENCY_AVAILABLE = "dependencyAvailable";
    public static final String PROP_DEPENDENCY_CHANGED = "dependencyChanged";
    public static final String PROP_DEPENDENCY_UNAVAILABLE = "dependencyUnavailable";
    public static final String PROP_ALL_DEPENDENCIES_AVAILABLE = "allDependenciesAvailable";
    private BundleContext myContext;
    private int myRequiredCount;
    private Map<String, SingleServiceListener> myDependencyTrackers;
    private Map<String, DependencyDescriptor> myDependencyDescMap;
    private Map<String, Object> myAvailableDependencies;
    private Map<String, Object> myRequiredDependencies;
    private boolean myListeningFlag;

    public ServiceDependenciesTracker(BundleContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myDependencyTrackers = new HashMap<String, SingleServiceListener>();
        this.myAvailableDependencies = new HashMap<String, Object>();
        this.myDependencyDescMap = new HashMap<String, DependencyDescriptor>();
        this.myRequiredDependencies = new HashMap<String, Object>();
        this.myListeningFlag = false;
    }

    public boolean dependenciesSatisfied() {
        return this.myRequiredCount == this.myRequiredDependencies.size();
    }

    public Map<String, Object> getAvailableDependencies() {
        return this.myAvailableDependencies;
    }

    public Map<String, Object> getRequiredDependencies() {
        return this.myRequiredDependencies;
    }

    public Object getDependency(String dependencyId) {
        return this.myAvailableDependencies.get(dependencyId);
    }

    public boolean addDependencyDescription(DependencyDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException();
        }
        return this.addDependencyDescription(descriptor.getServiceClass(), descriptor.getDependencyName(), descriptor.getServiceFilter(), descriptor.getDependencyType());
    }

    public boolean addDependencyDescription(Class clazz, String dependencyName, String filterString, DependencyDescriptor.DependencyType type) {
        if (clazz == null || dependencyName == null) {
            throw new NullPointerException();
        }
        if (this.myDependencyDescMap.containsKey(dependencyName)) {
            this.getLogger().warn("Unable to add dependency, name already in use: {0}.", (Object)dependencyName);
            return false;
        }
        if (type == null) {
            type = DependencyDescriptor.DependencyType.REQUIRED;
        }
        SingleServiceListener ssl = new SingleServiceListener(clazz, this.myContext, filterString);
        ssl.addPropertyChangeListener(new RequirementListener(dependencyName));
        this.myDependencyTrackers.put(dependencyName, ssl);
        this.myDependencyDescMap.put(dependencyName, new DependencyDescriptor(dependencyName, clazz, filterString, type));
        if (this.isRunning()) {
            return ssl.start();
        }
        return true;
    }

    public boolean removeDependencyTracker(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        SingleServiceListener ssl = this.myDependencyTrackers.remove(name);
        if (ssl == null) {
            return false;
        }
        ssl.dispose();
        this.myDependencyDescMap.remove(name);
        this.myAvailableDependencies.remove(name);
        this.myRequiredDependencies.remove(name);
        return true;
    }

    public void start() {
        this.myListeningFlag = true;
        this.myRequiredCount = 0;
        for (DependencyDescriptor desc : this.myDependencyDescMap.values()) {
            if (DependencyDescriptor.DependencyType.REQUIRED != desc.getDependencyType()) continue;
            ++this.myRequiredCount;
        }
        for (SingleServiceListener ssl : this.myDependencyTrackers.values()) {
            ssl.start();
        }
    }

    public boolean isRunning() {
        return this.myListeningFlag;
    }

    public void stop() {
        this.myListeningFlag = false;
        this.myAvailableDependencies.clear();
        for (SingleServiceListener ssl : this.myDependencyTrackers.values()) {
            ssl.stop();
        }
    }

    public void dispose() {
        this.myListeningFlag = false;
        this.clearAllListeners();
        for (SingleServiceListener ssl : this.myDependencyTrackers.values()) {
            ssl.dispose();
        }
        this.myAvailableDependencies.clear();
        this.myRequiredDependencies.clear();
        this.myDependencyDescMap.clear();
        this.myDependencyTrackers.clear();
        this.myRequiredCount = 0;
        this.myContext = null;
    }

    private synchronized void dependencyFound(String requirementId, Object req) {
        if (requirementId == null || req == null) {
            throw new NullPointerException();
        }
        DependencyDescriptor desc = this.myDependencyDescMap.get(requirementId);
        if (desc == null) {
            return;
        }
        if (DependencyDescriptor.DependencyType.REQUIRED == desc.getDependencyType()) {
            this.getLogger().info("Found required dependency: {0}", (Object)requirementId);
            this.myRequiredDependencies.put(requirementId, req);
        } else {
            this.getLogger().info("Found optional dependency: {0}", (Object)requirementId);
        }
        this.myAvailableDependencies.put(requirementId, req);
        this.firePropertyChange(PROP_DEPENDENCY_AVAILABLE, requirementId, req);
        this.checkRequiredDependencies();
    }

    private void checkRequiredDependencies() {
        if (!this.dependenciesSatisfied()) {
            return;
        }
        this.getLogger().info("All requirements present: {0}", (Object)Arrays.toString(this.myDependencyDescMap.keySet().toArray()));
        this.firePropertyChange(PROP_ALL_DEPENDENCIES_AVAILABLE, null, this.getAvailableDependencies());
    }

    private synchronized void dependencyChanged(String requirementId, Object req) {
        if (requirementId == null || req == null) {
            throw new NullPointerException();
        }
        DependencyDescriptor desc = this.myDependencyDescMap.get(requirementId);
        if (desc == null) {
            return;
        }
        if (DependencyDescriptor.DependencyType.REQUIRED == desc.getDependencyType()) {
            this.getLogger().info("Required dependency changed: {0}", (Object)requirementId);
            this.myRequiredDependencies.put(requirementId, req);
        } else {
            this.getLogger().info("Optional dependency changed: {0}", (Object)requirementId);
        }
        this.myAvailableDependencies.put(requirementId, req);
        this.firePropertyChange(PROP_DEPENDENCY_CHANGED, requirementId, req);
    }

    private synchronized void dependencyLost(String requirementId) {
        if (requirementId == null) {
            throw new NullPointerException();
        }
        DependencyDescriptor desc = this.myDependencyDescMap.get(requirementId);
        if (desc == null) {
            return;
        }
        if (DependencyDescriptor.DependencyType.REQUIRED == desc.getDependencyType()) {
            this.myRequiredDependencies.remove(requirementId);
            this.getLogger().info("Lost required dependency: {0}", (Object)requirementId);
        } else {
            this.getLogger().info("Lost optional dependency: {0}", (Object)requirementId);
        }
        this.myAvailableDependencies.remove(requirementId);
        this.firePropertyChange(PROP_DEPENDENCY_UNAVAILABLE, requirementId, null);
    }

    Logger getLogger() {
        return theLogger;
    }

    class RequirementListener
    implements PropertyChangeListener {
        private String myRequirementId;

        public RequirementListener(String requirementId) {
            this.myRequirementId = requirementId;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("serviceTracked".equals(evt.getPropertyName())) {
                this.track(evt.getOldValue(), evt.getNewValue());
            } else if ("serviceRemoved".equals(evt.getPropertyName())) {
                this.untrack(evt.getNewValue());
            }
        }

        private void track(Object oldVal, Object newVal) {
            if (oldVal == null) {
                ServiceDependenciesTracker.this.dependencyFound(this.myRequirementId, newVal);
            } else {
                ServiceDependenciesTracker.this.dependencyChanged(this.myRequirementId, newVal);
            }
        }

        private void untrack(Object obj) {
            ServiceDependenciesTracker.this.dependencyLost(this.myRequirementId);
        }
    }
}

