/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.position;

import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;

public class DoubleRange
implements NormalizableRange<Double> {
    private double myMin;
    private double myRange;
    private double myAMin;
    private double myAMax;

    public DoubleRange(double min, double max) {
        this.myMin = min;
        this.myRange = max - min;
        if (this.myRange == 0.0) {
            throw new IllegalArgumentException("Range cannot be zero.");
        }
        this.myAMin = min < max ? min : max;
        this.myAMax = min > max ? min : max;
    }

    @Override
    public boolean isValid(Double val) {
        if (val == null) {
            throw new NullPointerException();
        }
        return this.myAMin <= val && val <= this.myAMax;
    }

    @Override
    public NormalizedDouble normalizeValue(Double val) {
        if (!this.isValid(val)) {
            return null;
        }
        double norm = (val - this.myMin) / this.myRange;
        return new NormalizedDouble(norm);
    }

    @Override
    public Double denormalizeValue(NormalizedDouble v) {
        return v.getValue() * this.myRange + this.myMin;
    }

    @Override
    public Double getMin() {
        return this.myMin;
    }

    @Override
    public Double getMax() {
        return this.myRange + this.myMin;
    }
}

