/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.services.addon;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.services.addon.ServiceAddOn;
import org.robokind.api.common.services.addon.ServiceAddOnDriver;

public class AddOnUtils {
    private static final Logger theLogger = Logger.getLogger(AddOnUtils.class.getName());

    public static ServiceRegistration registerAddOnDriver(BundleContext context, ServiceAddOnDriver driver, Properties props) {
        Hashtable<String, Object> propTable = new Hashtable<String, Object>();
        if (context == null || driver == null) {
            throw new NullPointerException();
        }
        if (props != null) {
            for (Object prop : props.keySet()) {
                ((Dictionary)propTable).put(prop.toString(), props.get(prop));
            }
        }
        ((Dictionary)propTable).put("ServiceVersion", driver.getServiceVersion().toString());
        ((Dictionary)propTable).put("configFormatVersion", driver.getConfigurationFormat().toString());
        ServiceRegistration reg = context.registerService(ServiceAddOnDriver.class.getName(), (Object)driver, propTable);
        if (reg == null) {
            theLogger.log(Level.WARNING, "Unknown error occured while registering ServiceConfigurationWriter.");
        } else {
            theLogger.log(Level.INFO, "ServiceAddOnDriver registered successfully.");
        }
        return reg;
    }

    public static ServiceReference[] getAddOnDriverReferences(BundleContext context, VersionProperty serviceVersion, VersionProperty configFormat) {
        ServiceReference[] refs;
        if (context == null || serviceVersion == null || configFormat == null) {
            throw new NullPointerException();
        }
        Properties props = new Properties();
        props.put("ServiceVersion", serviceVersion.toString());
        props.put("configFormatVersion", configFormat.toString());
        String filter = OSGiUtils.createServiceFilter(props);
        try {
            refs = context.getServiceReferences(ServiceAddOnDriver.class.getName(), filter);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.SEVERE, "There was an error fetching service references.", ex);
            return null;
        }
        if (refs == null || refs.length == 0) {
            theLogger.log(Level.WARNING, "Unable to find AddOnDriver with serviceVersion={0} and configFormat={1}", new Object[]{serviceVersion.display(), configFormat.display()});
            return null;
        }
        return refs;
    }

    public static ServiceReference[] getAddOnDriverReferences(BundleContext context) {
        ServiceReference[] refs;
        if (context == null) {
            throw new NullPointerException();
        }
        try {
            refs = context.getServiceReferences(ServiceAddOnDriver.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.SEVERE, "There was an error fetching service references.", ex);
            return null;
        }
        if (refs == null || refs.length == 0) {
            theLogger.log(Level.WARNING, "Unable to find AddOnDrivers");
            return null;
        }
        return refs;
    }

    public static List<ServiceAddOnDriver> getAddOnDriverList(BundleContext context, ServiceReference[] refs) {
        if (context == null || refs == null) {
            throw new NullPointerException();
        }
        ArrayList<ServiceAddOnDriver> drivers = new ArrayList<ServiceAddOnDriver>();
        for (ServiceReference ref : refs) {
            ServiceAddOnDriver driver = OSGiUtils.getService(ServiceAddOnDriver.class, context, ref);
            if (driver == null) continue;
            drivers.add(driver);
        }
        return drivers;
    }

    public static void releaseAddOnDrivers(BundleContext context, ServiceReference[] refs) {
        if (context == null || refs == null) {
            throw new NullPointerException();
        }
        for (ServiceReference ref : refs) {
            context.ungetService(ref);
        }
    }

    public static boolean saveAddOnConfig(ServiceAddOn addon, String addonPath) throws Exception {
        File addonFile = new File(addonPath);
        ServiceAddOnDriver driver = addon.getAddOnDriver();
        return driver.writeServiceConfig(addon.getAddOn(), addonFile);
    }
}

