/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.property;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robokind.api.common.property.PropertyChangeActionBase;

public class PropertyChangeMonitor
implements PropertyChangeListener {
    protected Map<String, List<PropertyChangeActionBase>> myPropertyActions;

    public void addAction(String property, PropertyChangeActionBase action) {
        if (this.myPropertyActions == null) {
            this.myPropertyActions = new HashMap<String, List<PropertyChangeActionBase>>();
        }
        if (!this.myPropertyActions.containsKey(property)) {
            this.myPropertyActions.put(property, new ArrayList(1));
        }
        this.myPropertyActions.get(property).add(action);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.myPropertyActions == null) {
            return;
        }
        String name = evt.getPropertyName();
        List<PropertyChangeActionBase> actions = this.myPropertyActions.get(name);
        if (actions == null || actions.isEmpty()) {
            return;
        }
        for (PropertyChangeActionBase action : actions) {
            action.performAction(evt);
        }
    }
}

