/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.utils;

import java.util.logging.Logger;
import org.robokind.api.common.utils.TimeUtils;

public abstract class TimerLoop {
    private static final Logger theLogger = Logger.getLogger(TimerLoop.class.getName());
    private long myInterval;
    private boolean myStop = true;

    public TimerLoop(long interval) {
        this.myInterval = interval;
    }

    public void setIntervalLength(long interval) {
        this.myInterval = interval;
    }

    public long getIntervalLength() {
        return this.myInterval;
    }

    protected abstract void timerTick(long var1, long var3);

    public void start() {
        if (!this.myStop) {
            return;
        }
        this.myStop = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!TimerLoop.this.myStop) {
                    TimerLoop.this.timerStep();
                }
            }
        }).start();
    }

    public void stop() {
        this.myStop = true;
    }

    private void timerStep() {
        long start = TimeUtils.now();
        this.timerTick(start, this.myInterval);
        long elapsed = TimeUtils.now() - start;
        long sleep = this.myInterval - elapsed;
        if (sleep >= 0L) {
            TimeUtils.sleep(sleep);
        }
    }
}

