/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.api.common.position;

import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;

public class BooleanRange
implements NormalizableRange<Boolean> {
    public static final BooleanRange DEFAULT_RANGE = new BooleanRange(new NormalizedDouble(0.5));
    private NormalizedDouble myThreshold;

    public BooleanRange(NormalizedDouble threshold) {
        if (threshold == null) {
            throw new NullPointerException();
        }
        this.myThreshold = threshold;
    }

    @Override
    public boolean isValid(Boolean val) {
        return val != null;
    }

    @Override
    public NormalizedDouble normalizeValue(Boolean val) {
        return new NormalizedDouble(val != false ? 1.0 : 0.0);
    }

    @Override
    public Boolean denormalizeValue(NormalizedDouble v) {
        return v.getValue() >= this.myThreshold.getValue();
    }

    @Override
    public Boolean getMin() {
        return false;
    }

    @Override
    public Boolean getMax() {
        return true;
    }
}

